/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.json;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.hand.hap.core.util.TimeZoneUtil;
import java.io.IOException;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang.time.DateFormatUtils;

public class DateTimeSerializer
extends JsonSerializer<Date>
implements ContextualSerializer {
    private String pattern = "yyyy-MM-dd HH:mm:ss";

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void serialize(Date date, JsonGenerator jsonGenerator, SerializerProvider aSerializerProvider) throws IOException, JsonProcessingException {
        jsonGenerator.writeString(DateFormatUtils.format((Date)date, (String)this.getPattern(), (TimeZone)TimeZoneUtil.getTimeZone()));
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        DateTimeSerializer serializer = new DateTimeSerializer();
        if (property != null) {
            JsonFormat jf = (JsonFormat)property.getMember().getAnnotation(JsonFormat.class);
            if (jf != null && !"".equals(jf.pattern())) {
                serializer.setPattern(jf.pattern());
            }
        } else {
            serializer.setPattern(this.pattern);
        }
        return serializer;
    }
}

