/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.hand.hap.core.json.StringTrim;
import java.io.IOException;

public class CustomStringDeserializer
extends JsonDeserializer<String>
implements ContextualDeserializer {
    private boolean stringTrim = false;

    public boolean isStringTrim() {
        return this.stringTrim;
    }

    public void setStringTrim(boolean stringTrim) {
        this.stringTrim = stringTrim;
    }

    public String deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String str = jp.getText();
        if (this.isStringTrim()) {
            str = str.trim();
        }
        return str;
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        StringTrim stringTrim;
        CustomStringDeserializer deserializer = new CustomStringDeserializer();
        if (property != null && (stringTrim = (StringTrim)property.getMember().getAnnotation(StringTrim.class)) != null) {
            deserializer.setStringTrim(true);
        }
        return deserializer;
    }
}

