/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.impl;

import com.hand.hap.core.IRequest;
import com.hand.hap.core.IRequestListener;
import com.hand.hap.core.impl.DefaultRequestListener;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.MDC;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.i18n.SessionLocaleResolver;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.util.WebUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class RequestHelper {
    private static ThreadLocal<IRequest> localRequestContext = new ThreadLocal();
    private static IRequestListener requestListener = new DefaultRequestListener();

    public IRequestListener getRequestListener() {
        return requestListener;
    }

    public void setRequestListener(IRequestListener requestListener) {
        RequestHelper.requestListener = requestListener;
    }

    public static IRequest newEmptyRequest() {
        return requestListener.newInstance();
    }

    public static void setCurrentRequest(IRequest request) {
        localRequestContext.set(request);
    }

    public static void clearCurrentRequest() {
        localRequestContext.remove();
    }

    public static IRequest getCurrentRequest() {
        return RequestHelper.getCurrentRequest((boolean)false);
    }

    public static IRequest getCurrentRequest(boolean returnEmptyForNull) {
        IRequest request = (IRequest)localRequestContext.get();
        if (request == null && returnEmptyForNull) {
            return RequestHelper.newEmptyRequest();
        }
        return request;
    }

    public static IRequest createServiceRequest(HttpServletRequest httpServletRequest) {
        IRequest requestContext = requestListener.newInstance();
        HttpSession session = httpServletRequest.getSession(false);
        if (session != null) {
            Object roleIds;
            if (session.getAttribute("userId") != null) {
                requestContext.setUserId((Long)session.getAttribute("userId"));
            }
            if (session.getAttribute("roleId") != null) {
                requestContext.setRoleId((Long)session.getAttribute("roleId"));
            }
            if (session.getAttribute("userName") != null) {
                requestContext.setUserName((String)session.getAttribute("userName"));
            }
            if (session.getAttribute("companyId") != null) {
                requestContext.setCompanyId((Long)session.getAttribute("companyId"));
            }
            if ((roleIds = session.getAttribute("roleIds")) instanceof Long[]) {
                requestContext.setAllRoleId((Long[])roleIds);
            }
            requestContext.setEmployeeCode((String)session.getAttribute("employeeCode"));
            Locale locale = RequestHelper.getLocale((HttpServletRequest)httpServletRequest);
            if (locale != null) {
                requestContext.setLocale(locale.toString());
            }
        } else {
            OAuth2Authentication oauth2Authentication;
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            if (authentication instanceof OAuth2Authentication && (oauth2Authentication = (OAuth2Authentication)authentication).getUserAuthentication() != null) {
                requestContext.setUserName(oauth2Authentication.getPrincipal().toString());
                Map extensions = oauth2Authentication.getOAuth2Request().getExtensions();
                if (extensions.get("userId") != null) {
                    requestContext.setUserId(Long.valueOf(((Serializable)extensions.get("userId")).toString()));
                }
                if (extensions.get("roleIds") != null) {
                    List ids = (List)extensions.get("roleIds");
                    Long[] idsArry = new Long[ids.size()];
                    for (int i = 0; i < ids.size(); ++i) {
                        idsArry[i] = Long.valueOf(ids.get(i).toString());
                    }
                    requestContext.setAllRoleId(idsArry);
                }
                if (extensions.get("companyId") != null) {
                    requestContext.setCompanyId(Long.valueOf(((Serializable)extensions.get("companyId")).toString()));
                }
                if (extensions.get("employeeCode") != null) {
                    requestContext.setEmployeeCode(((Serializable)extensions.get("employeeCode")).toString());
                }
                if (extensions.get("locale") != null) {
                    requestContext.setLocale(((Serializable)extensions.get("locale")).toString());
                } else {
                    Locale locale = RequestHelper.getLocale((HttpServletRequest)httpServletRequest);
                    if (locale != null) {
                        requestContext.setLocale(locale.toString());
                    }
                }
            }
        }
        Map mdcMap = MDC.getCopyOfContextMap();
        if (mdcMap != null) {
            mdcMap.forEach((k, v) -> requestContext.setAttribute("MDC.".concat((String)k), v));
        }
        requestListener.afterInitialize(httpServletRequest, requestContext);
        return requestContext;
    }

    private static Locale getLocale(HttpServletRequest request) {
        Locale locale;
        LocaleResolver localeResolver = RequestContextUtils.getLocaleResolver((HttpServletRequest)request);
        if (localeResolver != null) {
            locale = localeResolver.resolveLocale(request);
        } else {
            locale = (Locale)WebUtils.getSessionAttribute((HttpServletRequest)request, (String)SessionLocaleResolver.LOCALE_SESSION_ATTRIBUTE_NAME);
            if (locale == null) {
                locale = request.getLocale();
            }
        }
        return locale;
    }
}

