/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.cache.impl;

import com.hand.hap.cache.impl.HashStringRedisCache;
import com.hand.hap.function.mapper.RoleFunctionMapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleFunctionCache
extends HashStringRedisCache<Long[]> {
    private String roleFunctionQuerySqlId = RoleFunctionMapper.class.getName() + ".selectAllRoleFunctions";
    private final Logger logger = LoggerFactory.getLogger(RoleFunctionCache.class);

    public RoleFunctionCache() {
        this.setLoadOnStartUp(true);
        this.setType(Long[].class);
    }

    public Long[] getValue(String key) {
        return (Long[])super.getValue(key);
    }

    public void setValue(String key, Long[] values) {
        super.setValue(key, (Object)values);
    }

    protected void initLoad() {
        block14: {
            HashMap<String, Set> roleFunctions = new HashMap<String, Set>();
            try (SqlSession sqlSession = this.getSqlSessionFactory().openSession();){
                sqlSession.select(this.roleFunctionQuerySqlId, resultContext -> {
                    Map value = (Map)resultContext.getResultObject();
                    String roleId = "" + value.get("ROLE_ID");
                    HashSet<Long> sets = (HashSet<Long>)roleFunctions.get(roleId);
                    if (sets == null) {
                        sets = new HashSet<Long>();
                        roleFunctions.put(roleId, sets);
                    }
                    Long resourceId = ((Number)value.get("FUNCTION_ID")).longValue();
                    sets.add(resourceId);
                });
                roleFunctions.forEach((k, v) -> this.setValue(k, v.toArray(new Long[v.size()])));
            }
            catch (Exception e) {
                if (!this.logger.isErrorEnabled()) break block14;
                this.logger.error("init role function cache exception: ", (Throwable)e);
            }
        }
    }
}

