/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.cache.impl;

import com.hand.hap.cache.impl.HashStringRedisCache;
import com.hand.hap.function.dto.ResourceCustomization;
import com.hand.hap.function.mapper.ResourceCustomizationMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceCustomizationCache
extends HashStringRedisCache<String[]> {
    private String resourceCustomizationAllQuerySqlId = ResourceCustomizationMapper.class.getName() + ".selectAllResourceCustomizations";
    private String resourceCustomizationQuerySqlId = ResourceCustomizationMapper.class.getName() + ".loadResourceCustomizationsByResourceId";
    private final Logger logger = LoggerFactory.getLogger(ResourceCustomizationCache.class);

    public ResourceCustomizationCache() {
        this.setLoadOnStartUp(true);
        this.setType(String[].class);
    }

    public String[] getValue(String key) {
        return (String[])super.getValue(key);
    }

    public void setValue(String key, String[] values) {
        super.setValue(key, (Object)values);
    }

    protected void initLoad() {
        block14: {
            HashMap<String, List> resourceCustomization = new HashMap<String, List>();
            try (SqlSession sqlSession = this.getSqlSessionFactory().openSession();){
                sqlSession.select(this.resourceCustomizationAllQuerySqlId, resultContext -> {
                    Map value = (Map)resultContext.getResultObject();
                    String resourceId = "" + value.get("RESOURCE_ID");
                    ArrayList<String> sets = (ArrayList<String>)resourceCustomization.get(resourceId);
                    if (sets == null) {
                        sets = new ArrayList<String>();
                        resourceCustomization.put(resourceId, sets);
                    }
                    String url = (String)value.get("URL");
                    sets.add(url);
                });
                resourceCustomization.forEach((k, v) -> this.setValue(k, v.toArray(new String[v.size()])));
            }
            catch (Exception e) {
                if (!this.logger.isErrorEnabled()) break block14;
                this.logger.error("init resource customization cache exception: ", (Throwable)e);
            }
        }
    }

    public void load(String resourceId) {
        block14: {
            HashMap<String, List> resourceCustomization = new HashMap<String, List>();
            super.remove(resourceId);
            try (SqlSession sqlSession = this.getSqlSessionFactory().openSession();){
                sqlSession.select(this.resourceCustomizationQuerySqlId, (Object)resourceId, resultContext -> {
                    ResourceCustomization value = (ResourceCustomization)resultContext.getResultObject();
                    ArrayList<String> sets = (ArrayList<String>)resourceCustomization.get(resourceId);
                    if (sets == null) {
                        sets = new ArrayList<String>();
                        resourceCustomization.put(resourceId, sets);
                    }
                    sets.add(value.getUrl());
                });
                resourceCustomization.forEach((k, v) -> this.setValue(k, v.toArray(new String[v.size()])));
            }
            catch (Exception e) {
                if (!this.logger.isErrorEnabled()) break block14;
                this.logger.error("load resource customization cache exception: ", (Throwable)e);
            }
        }
    }
}

