/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.cache.impl;

import com.hand.hap.cache.Cache;
import com.hand.hap.cache.ICacheListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;

/*
 * Exception performing whole class analysis ignored.
 */
public class RedisCache<T>
implements Cache<T>,
BeanNameAware {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private SqlSessionFactory sqlSessionFactory;
    private RedisTemplate<String, String> redisTemplate;
    private ICacheListener listener;
    private String name;
    private Class<?> type;
    private String[] keyField;
    private String category = "hap:cache";
    private boolean loading = false;
    private int db;
    private boolean loadOnStartUp = false;
    private String sqlId;
    protected RedisSerializer<String> strSerializer;

    public void init() {
        this.strSerializer = this.redisTemplate.getStringSerializer();
        if (this.loadOnStartUp) {
            this.loading = true;
            try {
                this.initLoad();
            }
            finally {
                this.loading = false;
            }
        }
        if (this.listener != null) {
            this.listener.cacheInit((Cache)this);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public boolean isLoadOnStartUp() {
        return this.loadOnStartUp;
    }

    public void setLoadOnStartUp(boolean loadOnStartUp) {
        this.loadOnStartUp = loadOnStartUp;
    }

    public String getSqlId() {
        return this.sqlId;
    }

    public void setSqlId(String sqlId) {
        this.sqlId = sqlId;
    }

    public String[] getKeyField() {
        return this.keyField;
    }

    public void setKeyField(String[] keyField) {
        this.keyField = keyField;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public RedisTemplate<String, String> getRedisTemplate() {
        return this.redisTemplate;
    }

    @Autowired
    public void setRedisTemplate(RedisTemplate<String, String> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public SqlSessionFactory getSqlSessionFactory() {
        return this.sqlSessionFactory;
    }

    @Autowired
    @Qualifier(value="sqlSessionFactory")
    public void setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
    }

    public T getValue(String key) {
        return (T)this.redisTemplate.execute(connection -> {
            byte[] keyBytes = this.strSerializer.serialize((Object)this.getFullKey(key));
            Map value = connection.hGetAll(keyBytes);
            if (value.size() == 0) {
                return null;
            }
            try {
                Object bean = this.type.newInstance();
                for (Map.Entry entry : value.entrySet()) {
                    String pName = (String)this.strSerializer.deserialize((byte[])entry.getKey());
                    String pValue = (String)this.strSerializer.deserialize((byte[])entry.getValue());
                    if (bean instanceof Map) {
                        ((Map)bean).put(pName, pValue);
                        continue;
                    }
                    PropertyDescriptor pd = PropertyUtils.getPropertyDescriptor(bean, (String)pName);
                    if (pd == null) continue;
                    Class<?> pType2 = pd.getPropertyType();
                    if (pType2 == Date.class) {
                        Long time = pValue.length() == 0 ? null : Long.valueOf(Long.parseLong(pValue));
                        BeanUtils.setProperty(bean, (String)pName, (Object)time);
                        continue;
                    }
                    BeanUtils.setProperty(bean, (String)pName, (Object)pValue);
                }
                return bean;
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
    }

    public void setValue(String key, T value) {
        block2: {
            try {
                Map map = this.convertToMap(value);
                this.setValue(key, map);
            }
            catch (Exception e) {
                if (!this.logger.isErrorEnabled()) break block2;
                this.logger.error("setValue error ", (Throwable)e);
            }
        }
    }

    public void remove(String key) {
        this.redisTemplate.execute(connection -> {
            byte[] keyBytes = this.strSerializer.serialize((Object)this.getFullKey(key));
            connection.del((byte[][])new byte[][]{keyBytes});
            return null;
        });
    }

    public String getCacheKey(T value) {
        try {
            return RedisCache.getKeyOfBean(value, (String[])this.keyField);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void reload() {
        this.loading = true;
        try {
            this.clear();
            this.initLoad();
        }
        finally {
            this.loading = false;
        }
    }

    protected boolean isLoading() {
        return this.loading;
    }

    private void setValue(String key, Map<String, Object> value) {
        byte[] keyBytes = this.strSerializer.serialize((Object)this.getFullKey(key));
        HashMap data = new HashMap();
        value.forEach((k, v) -> {
            if (k.charAt(0) == '_') {
                return;
            }
            if (v instanceof Date) {
                v = ((Date)v).getTime();
            }
            if (v != null) {
                data.put(this.strSerializer.serialize(k), this.strSerializer.serialize((Object)v.toString()));
            }
        });
        this.redisTemplate.execute(connection -> {
            connection.hMSet(keyBytes, data);
            return null;
        });
    }

    protected void initLoad() {
        block14: {
            try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
                sqlSession.select(this.sqlId, resultContext -> {
                    Object row = resultContext.getResultObject();
                    this.handleRow(row);
                });
            }
            catch (Exception e) {
                if (!this.logger.isErrorEnabled()) break block14;
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void handleRow(Object row) {
        block2: {
            try {
                Map rowMap = this.convertToMap(row);
                String key = RedisCache.getKeyOfBean((Object)row, (String[])this.keyField);
                this.setValue(key, rowMap);
            }
            catch (Exception e) {
                if (!this.logger.isErrorEnabled()) break block2;
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static String getKeyOfBean(Object bean, String[] properties) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        String key = BeanUtils.getProperty((Object)bean, (String)properties[0]);
        if (properties.length > 1) {
            StringBuilder sb = new StringBuilder(key);
            for (int i = 1; i < properties.length; ++i) {
                sb.append('.').append(BeanUtils.getProperty((Object)bean, (String)properties[i]));
            }
            key = sb.toString();
        }
        return key;
    }

    private Map<String, Object> convertToMap(Object obj) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (obj instanceof Map) {
            return (Map)obj;
        }
        Map map = PropertyUtils.describe((Object)obj);
        map.remove("class");
        return map;
    }

    protected String getFullKey(String key) {
        return this.getCategory() + ":" + this.getName() + ":" + key;
    }

    public void clear() {
    }

    public void setListener(ICacheListener listener) {
        this.listener = listener;
    }

    public void setBeanName(String name) {
        if (this.getName() == null) {
            this.setName(name);
        }
    }

    protected void onCacheReload() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("cache reloaded:" + this.getName());
        }
    }
}

