/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.cache.impl;

import com.hand.hap.cache.impl.HashStringRedisCache;
import com.hand.hap.mail.dto.MessageTemplate;
import com.hand.hap.mail.mapper.MessageTemplateMapper;
import java.util.HashMap;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageTemplateCache
extends HashStringRedisCache<MessageTemplate> {
    private String messageTemplateQueryAllSqlId = MessageTemplateMapper.class.getName() + ".selectAll";
    private String messageTemplateQuerySqlId = MessageTemplateMapper.class.getName() + ".selectByCode";
    private final Logger logger = LoggerFactory.getLogger(MessageTemplateCache.class);

    public MessageTemplateCache() {
        this.setLoadOnStartUp(true);
        this.setType(MessageTemplate.class);
    }

    public MessageTemplate getValue(String key) {
        return (MessageTemplate)super.getValue(key);
    }

    public void setValue(String key, MessageTemplate value) {
        super.setValue(key, (Object)value);
    }

    protected void initLoad() {
        block15: {
            HashMap<String, MessageTemplate> messageTemplateMap = new HashMap<String, MessageTemplate>();
            try (SqlSession sqlSession = this.getSqlSessionFactory().openSession();){
                sqlSession.select(this.messageTemplateQueryAllSqlId, resultContext -> {
                    MessageTemplate messageTemplate = (MessageTemplate)resultContext.getResultObject();
                    messageTemplateMap.put(messageTemplate.getTemplateCode(), messageTemplate);
                });
                messageTemplateMap.forEach((k, v) -> this.setValue(k, v));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("successfully loaded all message template cache");
                }
            }
            catch (Throwable e) {
                if (!this.logger.isErrorEnabled()) break block15;
                this.logger.error("init message template cache exception: ", e);
            }
        }
    }

    public void reload(String templateCode) {
        block14: {
            super.remove(templateCode);
            try (SqlSession sqlSession = this.getSqlSessionFactory().openSession();){
                sqlSession.select(this.messageTemplateQuerySqlId, (Object)templateCode, resultContext -> {
                    MessageTemplate messageTemplate = (MessageTemplate)resultContext.getResultObject();
                    this.setValue(messageTemplate.getTemplateCode(), messageTemplate);
                });
            }
            catch (Throwable e) {
                if (!this.logger.isErrorEnabled()) break block14;
                this.logger.error("load message template cache exception: ", e);
            }
        }
    }
}

