/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.cache.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hand.hap.cache.impl.RedisCache;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisConnection;

/*
 * Exception performing whole class analysis ignored.
 */
public class HashStringRedisCache<T>
extends RedisCache<T> {
    private ObjectMapper objectMapper;
    private String valueField;
    private boolean isBasic = false;
    private Constructor stringConstructor;
    private Logger logger = LoggerFactory.getLogger(HashStringRedisCache.class);
    private String fullKey;
    private String topic;

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Autowired
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setType(Class<?> type) {
        super.setType(type);
        if (String.class == type || Boolean.class == type || Number.class.isAssignableFrom(type)) {
            this.isBasic = true;
        }
        if (this.isBasic) {
            try {
                this.stringConstructor = type.getConstructor(String.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void setName(String name) {
        super.setName(name);
        this.topic = "cache." + name;
    }

    public T getValue(String key) {
        return (T)this.getRedisTemplate().execute(connection -> this.hMGet(connection, this.getFullKey(key), key));
    }

    public void setValue(String key, T value) {
        if (value == null) {
            this.remove(key);
            return;
        }
        this.getRedisTemplate().execute(connection -> {
            try {
                this.hMSet(connection, this.getFullKey(key), key, value);
            }
            catch (JsonProcessingException e) {
                this.logger.error("JsonProcessingException: ", (Throwable)e);
            }
            return null;
        });
        if (!this.isLoading()) {
            this.getRedisTemplate().convertAndSend(this.topic, (Object)key);
        }
    }

    protected String objectToString(Object value) {
        if (this.isBasic) {
            return String.valueOf(value);
        }
        try {
            return this.objectMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("invalid json: " + value);
            }
            throw new RuntimeException(e);
        }
    }

    protected T stringToObject(String value) {
        if (this.isBasic) {
            try {
                return this.stringConstructor.newInstance(value);
            }
            catch (Exception e) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("invalid value: " + value);
                }
                throw new RuntimeException(e);
            }
        }
        try {
            return (T)this.objectMapper.readValue(value, this.getType());
        }
        catch (Exception e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("invalid value: " + value);
            }
            throw new RuntimeException(e);
        }
    }

    protected void hMSet(RedisConnection connection, String mapKey, String pName, Object pValue) throws JsonProcessingException {
        String string = this.objectToString(pValue);
        HashMap<byte[], byte[]> v = new HashMap<byte[], byte[]>();
        v.put(this.strSerializer.serialize((Object)pName), this.strSerializer.serialize((Object)string));
        connection.hMSet(this.strSerializer.serialize((Object)mapKey), v);
    }

    protected <E> E hMGet(RedisConnection connection, String mapKey, String pName) {
        byte[] mapKeyBytes = this.strSerializer.serialize((Object)mapKey);
        List result = connection.hMGet(mapKeyBytes, (byte[][])new byte[][]{this.strSerializer.serialize((Object)pName)});
        if (result.isEmpty() || result.get(0) == null) {
            return null;
        }
        String string = (String)this.strSerializer.deserialize((byte[])result.get(0));
        Object obj = this.stringToObject(string);
        return (E)obj;
    }

    protected <E> List<E> hVals(RedisConnection connection, String mapKey) {
        byte[] mapKeyBytes = this.strSerializer.serialize((Object)mapKey);
        List result = connection.hVals(mapKeyBytes);
        ArrayList<Object> list = new ArrayList<Object>();
        for (byte[] bs : result) {
            String string = (String)this.strSerializer.deserialize(bs);
            Object obj = this.stringToObject(string);
            list.add(obj);
        }
        return list;
    }

    public List<T> getAll() {
        return (List)this.getRedisTemplate().execute(connection -> this.hVals(connection, this.getFullKey(null)));
    }

    public void remove(String key) {
        this.getRedisTemplate().execute(connection -> {
            byte[] mapKeyBytes = this.strSerializer.serialize((Object)this.getFullKey(key));
            byte[] valueKeyBytes = this.strSerializer.serialize((Object)key);
            connection.hDel(mapKeyBytes, (byte[][])new byte[][]{valueKeyBytes});
            return null;
        });
        if (!this.isLoading()) {
            this.getRedisTemplate().convertAndSend(this.topic, (Object)key);
        }
    }

    protected void handleRow(Object row) {
        block4: {
            try {
                String[] keyField = this.getKeyField();
                String key = HashStringRedisCache.getKeyOfBean((Object)row, (String[])keyField);
                if (this.valueField != null) {
                    String v = BeanUtils.getProperty((Object)row, (String)this.valueField);
                    this.setValue(key, (Object)v);
                } else {
                    this.setValue(key, row);
                }
            }
            catch (Exception e) {
                if (!this.logger.isErrorEnabled()) break block4;
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected String getFullKey(String key) {
        if (this.fullKey == null) {
            this.fullKey = this.getCategory() + ":" + this.getName();
        }
        return this.fullKey;
    }

    public void clear() {
        this.getRedisTemplate().execute(connection -> {
            connection.del((byte[][])new byte[][]{this.strSerializer.serialize((Object)this.getFullKey(null))});
            return null;
        });
    }

    public String getValueField() {
        return this.valueField;
    }

    public void setValueField(String valueField) {
        this.valueField = valueField;
    }
}

