/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.attachment.controllers;

import com.hand.hap.attachment.dto.SysFile;
import com.hand.hap.attachment.service.ISysFileService;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.exception.TokenException;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.BaseDTO;
import com.hand.hap.system.dto.ResponseData;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class SysFileController
extends BaseController {
    @Autowired
    private ISysFileService sysFileService;

    @RequestMapping(value={"/sys/attach/file/query"})
    public ResponseData query(HttpServletRequest request, SysFile sysFile, Long categoryId, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize) {
        IRequest requestCtx = this.createRequestContext(request);
        return new ResponseData(this.sysFileService.selectFilesByCategoryId(requestCtx, sysFile, categoryId, page, pagesize));
    }

    @RequestMapping(value={"/sys/attachment/query"})
    public ResponseData queryFilesBySourceTypeAndSourceKey(HttpServletRequest request, String sourceType, String sourceKey) {
        return new ResponseData(this.sysFileService.selectFilesBySourceTypeAndSourceKey(this.createRequestContext(request), sourceType, sourceKey));
    }

    @RequestMapping(value={"/sys/attach/file/queryFiles"})
    public ResponseData query(HttpServletRequest request, SysFile sysFile, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize) {
        IRequest requestCtx = this.createRequestContext(request);
        return new ResponseData(this.sysFileService.selectFiles(requestCtx, sysFile, page, pagesize));
    }

    @RequestMapping(value={"/sys/attach/file/remove"})
    public ResponseData remove(HttpServletRequest request, @RequestBody List<SysFile> sysFiles) {
        IRequest requestContext = this.createRequestContext(request);
        this.sysFileService.removeFiles(requestContext, sysFiles);
        return new ResponseData();
    }

    @RequestMapping(value={"/sys/attach/file/delete"})
    public ResponseData deleteFile(HttpServletRequest request, @RequestBody SysFile file) throws TokenException {
        this.checkToken(request, (BaseDTO)file);
        IRequest requestContext = this.createRequestContext(request);
        this.sysFileService.deletefiles(requestContext, file);
        return new ResponseData(Arrays.asList(file));
    }
}

