/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.api.logs.service.impl;

import com.hand.hap.api.gateway.dto.ApiServer;
import com.hand.hap.api.logs.dto.ApiInvokeRecord;
import com.hand.hap.api.logs.info.ApiInvokeInfo;
import com.hand.hap.intergration.exception.HapApiException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class ApiInvokeExecutionAdvice
implements MethodInterceptor {
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object result;
        Long startTime = System.currentTimeMillis();
        ApiInvokeRecord apiInvokeRecord = (ApiInvokeRecord)ApiInvokeInfo.API_INVOKE_RECORD.get();
        Object[] args = invocation.getArguments();
        ApiServer server = (ApiServer)args[0];
        String parameter = (String)args[1];
        try {
            apiInvokeRecord.setServerCode(server.getCode());
            apiInvokeRecord.setServerName(server.getName());
            apiInvokeRecord.setInterfaceType(server.getServiceType());
            if (server.getServiceType().equals("SOAP")) {
                apiInvokeRecord.setRequestUrl(server.getDomainUrl() != null ? server.getDomainUrl() : "");
            } else {
                apiInvokeRecord.setRequestUrl((server.getDomainUrl() != null ? server.getDomainUrl() : "") + (server.getApiInterface().getInterfaceUrl() != null ? server.getApiInterface().getInterfaceUrl() : ""));
            }
            result = invocation.proceed();
            if ("Y".equals(server.getApiInterface().getInvokeRecordDetails())) {
                apiInvokeRecord.getApiInvokeRecordDetails().setRequestBodyParameter(parameter);
                apiInvokeRecord.getApiInvokeRecordDetails().setResponseContent(result.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            apiInvokeRecord.getApiInvokeRecordDetails().setRequestBodyParameter(parameter);
            if (e instanceof HapApiException && ((HapApiException)e).getCode().startsWith("API_THIRD_PARTY_REQUEST")) {
                apiInvokeRecord.getApiInvokeRecordDetails().setResponseContent(((HapApiException)e).getDescriptionKey());
            }
            throw e;
        }
        finally {
            apiInvokeRecord.setResponseTime(Long.valueOf(System.currentTimeMillis() - startTime));
        }
        return result;
    }
}

