/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.api.application.controllers;

import com.hand.hap.api.application.dto.ApiApplication;
import com.hand.hap.api.application.service.IApiApplicationService;
import com.hand.hap.api.gateway.dto.ApiServer;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/application/app", "/api/sys/application/app"})
public class ApiApplicationController
extends BaseController {
    @Autowired
    private IApiApplicationService service;

    @RequestMapping(value={"/query"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseData query(ApiApplication dto, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pageSize, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.service.selectApplications(requestContext, dto, page, pageSize));
    }

    @PostMapping(value={"/{applicationId}/detail"})
    public ResponseData queryDetail(HttpServletRequest request, @PathVariable Long applicationId) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(Arrays.asList(this.service.getById(requestContext, applicationId)));
    }

    @PostMapping(value={"/fetchNotServer"})
    public ResponseData fetch(HttpServletRequest request, String exitsCodes, ApiServer server, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize) {
        IRequest requestContext = this.createRequestContext(request);
        List apiServers = this.service.selectNotExistsServerByApp(requestContext, exitsCodes, server, page, pagesize);
        return new ResponseData(apiServers);
    }

    @PostMapping(value={"/submit"})
    public ResponseData update(@RequestBody List<ApiApplication> dto, BindingResult result, HttpServletRequest request) {
        this.getValidator().validate(dto, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        IRequest requestCtx = this.createRequestContext(request);
        return new ResponseData(this.service.batchUpdate(requestCtx, dto));
    }

    @PostMapping(value={"/remove"})
    public ResponseData remove(HttpServletRequest request, @RequestBody List<ApiApplication> dto) {
        this.service.batchDelete(dto);
        return new ResponseData();
    }

    @PostMapping(value={"/generatorClientInfo"})
    public Map generatorClientInfo() {
        HashMap<String, String> clientInfo = new HashMap<String, String>(1);
        clientInfo.put("clientId", UUID.randomUUID().toString().replaceAll("\\-", ""));
        clientInfo.put("clientSecret", UUID.randomUUID().toString());
        return clientInfo;
    }
}

