/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.account.service.impl;

import com.hand.hap.account.dto.UserRole;
import com.hand.hap.account.mapper.UserRoleMapper;
import com.hand.hap.account.service.IUserRoleService;
import com.hand.hap.cache.impl.UserCache;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserRoleServiceImpl
extends BaseServiceImpl<UserRole>
implements IUserRoleService {
    @Autowired
    private UserRoleMapper userRoleMapper;
    @Autowired
    private UserCache userCache;

    @Transactional(rollbackFor={Exception.class})
    public List<UserRole> batchUpdate(IRequest request, List<UserRole> list) {
        for (UserRole userRole : list) {
            switch (userRole.get__status()) {
                case "add": {
                    ((IUserRoleService)this.self()).insertSelective(request, (Object)userRole);
                    break;
                }
                case "delete": {
                    ((IUserRoleService)this.self()).deleteByPrimaryKey((Object)userRole);
                    break;
                }
            }
            this.userCache.remove(userRole.getUserName());
        }
        return list;
    }

    @Transactional(rollbackFor={Exception.class})
    public int deleteByPrimaryKey(UserRole record) {
        if (record.getSurId() != null) {
            return super.deleteByPrimaryKey((Object)record);
        }
        int updateCount = this.userRoleMapper.deleteByRecord(record);
        this.checkOvn(updateCount, (Object)record);
        return updateCount;
    }
}

