/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.task.service.impl;

import com.github.pagehelper.StringUtil;
import com.hand.hap.core.AppContextInitListener;
import com.hand.hap.core.impl.RequestHelper;
import com.hand.hap.message.TaskListenerContainer;
import com.hand.hap.task.dto.TaskDetail;
import com.hand.hap.task.dto.TaskExecution;
import com.hand.hap.task.exception.TaskInterruptException;
import com.hand.hap.task.info.ExecutionInfo;
import com.hand.hap.task.info.ParameterInfo;
import com.hand.hap.task.info.TaskDataInfo;
import com.hand.hap.task.info.ThreadManageInfo;
import com.hand.hap.task.service.IExecuteListener;
import com.hand.hap.task.service.IExecuteService;
import com.hand.hap.task.service.ITask;
import com.hand.hap.task.service.ITaskDetailService;
import com.hand.hap.task.service.ITaskExecutionService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Service
public class ExecuteServiceImpl
implements IExecuteService,
AppContextInitListener {
    @Autowired
    private ThreadPoolTaskExecutor taskExecutor;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ITaskDetailService taskDetailService;
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired
    private ITaskExecutionService taskExecutionService;
    private List<IExecuteListener> executeListeners = Collections.emptyList();

    @Override
    public void taskExecute(TaskDataInfo taskDataInfo) {
        TaskThread taskThread = new TaskThread(taskDataInfo);
        taskThread.setName("TASKQUEUE-" + taskDataInfo.getExecutionId());
        try {
            this.taskExecutor.execute((Runnable)taskThread);
        }
        catch (RejectedExecutionException e) {
            this.taskExecutionService.updateStatus(taskDataInfo.getExecutionId(), "UNEXECUTED");
            this.taskExecutionService.batchUpdateStatus(taskDataInfo.getExecutionId(), "READY", "UNEXECUTED");
            throw e;
        }
    }

    @Override
    public void contextInitialized(ApplicationContext applicationContext) {
        this.executeListeners = new ArrayList(applicationContext.getBeansOfType(IExecuteListener.class).values());
        this.executeListeners.sort(Comparator.comparingInt(IExecuteListener::getOrder));
    }

    private class TaskThread
    extends Thread {
        private TaskDataInfo taskDataInfo = null;
        private boolean isSuccess = true;

        private TaskThread(TaskDataInfo taskDataInfo) {
            this.taskDataInfo = taskDataInfo;
        }

        @Override
        public void run() {
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            def.setPropagationBehavior(0);
            TransactionStatus status = ExecuteServiceImpl.this.transactionManager.getTransaction((TransactionDefinition)def);
            Thread thread = Thread.currentThread();
            thread.setName("TASK-" + this.taskDataInfo.getExecutionId());
            ThreadManageInfo.threadHashMap.put(thread.getName(), thread);
            this.execute(this.taskDataInfo);
            if (!TaskListenerContainer.running) {
                if (this.isSuccess && !thread.isInterrupted()) {
                    ExecuteServiceImpl.this.transactionManager.commit(status);
                } else if (!this.isSuccess) {
                    ExecuteServiceImpl.this.transactionManager.rollback(status);
                } else if (thread.isInterrupted()) {
                    ExecuteServiceImpl.this.transactionManager.rollback(status);
                    this.updateStatus(this.taskDataInfo);
                }
                ThreadManageInfo.threadHashMap.remove(thread.getName());
            }
        }

        private void execute(TaskDataInfo taskDataInfo) {
            if (taskDataInfo.getType().equals("TASK")) {
                this.executeTask(taskDataInfo);
            } else {
                for (int i = 0; i < taskDataInfo.getTaskDatas().size(); ++i) {
                    if (!this.isSuccess || Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    taskDataInfo.setCurrentExecution(i);
                    taskDataInfo.setCurrentTask(taskDataInfo.getTaskDatas().get(i));
                    this.executeTask(taskDataInfo);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeTask(TaskDataInfo taskDataInfo) {
            String executeResultPath = "";
            try {
                ExecuteServiceImpl.this.executeListeners.forEach(executeListener -> executeListener.before(taskDataInfo));
                executeResultPath = this.operate(taskDataInfo);
                if (!Thread.currentThread().isInterrupted()) {
                    ExecuteServiceImpl.this.executeListeners.forEach(executeListener -> executeListener.after(taskDataInfo));
                }
                if (StringUtil.isNotEmpty(executeResultPath)) {
                    TaskExecution taskExecution = new TaskExecution();
                    taskExecution.setExecuteResultPath(executeResultPath);
                    if (taskDataInfo.getType().equals("TASK")) {
                        taskExecution.setExecutionId(taskDataInfo.getExecutionId());
                    } else {
                        taskExecution.setExecutionId(taskDataInfo.getCurrentTask().getExecutionId());
                    }
                    ExecuteServiceImpl.this.taskExecutionService.updateByPrimaryKeySelective(RequestHelper.newEmptyRequest(), taskExecution);
                }
            }
            catch (TaskInterruptException taskExecution) {
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                this.isSuccess = false;
                ExecuteServiceImpl.this.executeListeners.forEach(executeListener -> executeListener.doException(e, taskDataInfo));
            }
            finally {
                ExecuteServiceImpl.this.executeListeners.sort((a, b) -> b.getOrder() - a.getOrder());
                ExecuteServiceImpl.this.executeListeners.forEach(executeListener -> executeListener.doFinally(taskDataInfo));
            }
        }

        private String operate(TaskDataInfo taskDataInfo) throws Exception {
            String taskClass = "";
            taskClass = taskDataInfo.getType().equals("TASK") ? taskDataInfo.getTaskClass() : taskDataInfo.getCurrentTask().getTaskClass();
            ITask task = (ITask)Class.forName(taskClass.trim()).newInstance();
            ExecuteServiceImpl.this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)task);
            ExecutionInfo executionInfo = this.translateExecutionInfo(taskDataInfo);
            task.execute(executionInfo);
            return executionInfo.getExecuteResultPath();
        }

        private ExecutionInfo translateExecutionInfo(TaskDataInfo taskDataInfo) {
            ExecutionInfo executionInfo = new ExecutionInfo();
            executionInfo.setUsername(taskDataInfo.getUsername());
            Map<String, Object> map = this.transformMap(taskDataInfo);
            executionInfo.setParam(map);
            TaskDetail taskDetail = new TaskDetail();
            taskDetail.setTaskId(taskDataInfo.getTaskId());
            taskDetail = ExecuteServiceImpl.this.taskDetailService.selectByPrimaryKey(RequestHelper.newEmptyRequest(), taskDetail);
            executionInfo.setTaskDetail(taskDetail);
            return executionInfo;
        }

        private Map<String, Object> transformMap(TaskDataInfo taskDataInfo) {
            HashMap<String, Object> parameterMap = new HashMap<String, Object>(16);
            List<ParameterInfo> parameterInfoList = taskDataInfo.getType().equals("TASK") ? taskDataInfo.getParam() : taskDataInfo.getCurrentTask().getParam();
            for (ParameterInfo parameterInfo : parameterInfoList) {
                parameterMap.put(parameterInfo.getKey(), parameterInfo.getValue());
            }
            return parameterMap;
        }

        private void updateStatus(TaskDataInfo taskDataInfo) {
            ExecuteServiceImpl.this.taskExecutionService.updateStatus(taskDataInfo.getExecutionId(), "CANCEL");
            if (taskDataInfo.getType().equals("GROUP")) {
                ExecuteServiceImpl.this.taskExecutionService.batchUpdateStatus(taskDataInfo.getExecutionId(), "SUCCESS", "ROLLBACK");
                ExecuteServiceImpl.this.taskExecutionService.batchUpdateStatus(taskDataInfo.getExecutionId(), "READY", "UNEXECUTED");
                ExecuteServiceImpl.this.taskExecutionService.updateStatus(taskDataInfo.getCurrentTask().getExecutionId(), "CANCEL");
            }
        }
    }
}

