/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.task.service.impl;

import com.hand.hap.message.IMessagePublisher;
import com.hand.hap.task.dto.TaskExecutionDetail;
import com.hand.hap.task.info.TaskDataInfo;
import com.hand.hap.task.info.TaskExecuteInfo;
import com.hand.hap.task.service.IExecuteListener;
import com.hand.hap.task.service.ITaskExecutionDetailService;
import com.hand.hap.task.service.ITaskExecutionService;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExecuteListener
implements IExecuteListener {
    public static final int ORDER = 1;
    @Autowired
    private IMessagePublisher messagePublisher;
    @Autowired
    private ITaskExecutionDetailService iTaskExecutionDetailService;
    @Autowired
    private ITaskExecutionService taskExecutionService;

    @Override
    public void before(TaskDataInfo taskDataInfo) {
        MDC.put((String)"TYPE", (String)"TASK");
        TaskExecuteInfo.TASK_LOG.set(new StringBuffer());
        if (taskDataInfo.getType().equals("TASK")) {
            this.taskExecutionService.updateStatus(taskDataInfo.getExecutionId(), "EXECUTING");
        } else if (taskDataInfo.getCurrentExecution() == 0) {
            this.taskExecutionService.updateStatus(taskDataInfo.getExecutionId(), "EXECUTING");
            this.taskExecutionService.updateStatus(taskDataInfo.getCurrentTask().getExecutionId(), "EXECUTING");
        } else {
            this.taskExecutionService.updateStatus(taskDataInfo.getCurrentTask().getExecutionId(), "EXECUTING");
        }
    }

    @Override
    public void after(TaskDataInfo taskDataInfo) {
        if (taskDataInfo.getType().equals("TASK")) {
            this.taskExecutionService.updateStatus(taskDataInfo.getExecutionId(), "SUCCESS");
        } else if (taskDataInfo.getCurrentExecution() == taskDataInfo.getTaskDatas().size() - 1) {
            this.taskExecutionService.updateStatus(taskDataInfo.getExecutionId(), "SUCCESS");
            this.taskExecutionService.updateStatus(taskDataInfo.getCurrentTask().getExecutionId(), "SUCCESS");
        } else {
            this.taskExecutionService.updateStatus(taskDataInfo.getCurrentTask().getExecutionId(), "SUCCESS");
        }
    }

    @Override
    public void doException(Exception e, TaskDataInfo taskDataInfo) {
        if (taskDataInfo.getType().equals("TASK")) {
            this.taskExecutionService.updateStatus(taskDataInfo.getExecutionId(), "FAILURE");
            this.updateExecutionDetailStacktrace(e, taskDataInfo);
        } else {
            this.taskExecutionService.updateStatus(taskDataInfo.getExecutionId(), "FAILURE");
            this.taskExecutionService.updateStatus(taskDataInfo.getCurrentTask().getExecutionId(), "FAILURE");
            this.updateExecutionDetailStacktrace(e, taskDataInfo.getCurrentTask());
            this.taskExecutionService.batchUpdateStatus(taskDataInfo.getExecutionId(), "SUCCESS", "ROLLBACK");
            this.taskExecutionService.batchUpdateStatus(taskDataInfo.getExecutionId(), "READY", "UNEXECUTED");
        }
    }

    @Override
    public void doFinally(TaskDataInfo taskDataInfo) {
        TaskExecutionDetail taskExecutionDetail = new TaskExecutionDetail();
        taskExecutionDetail.setExecutionLog(TaskExecuteInfo.TASK_LOG.get().toString());
        MDC.remove((String)"TYPE");
        TaskExecuteInfo.clear();
        if (taskDataInfo.getType().equals("TASK")) {
            taskExecutionDetail.setExecutionId(taskDataInfo.getExecutionId());
        } else {
            taskExecutionDetail.setExecutionId(taskDataInfo.getCurrentTask().getExecutionId());
        }
        this.messagePublisher.publish("task_execute_log", taskExecutionDetail);
    }

    private void updateExecutionDetailStacktrace(Exception e, TaskDataInfo taskData) {
        TaskExecutionDetail taskExecutionDetail = new TaskExecutionDetail();
        taskExecutionDetail.setExecutionId(taskData.getExecutionId());
        this.iTaskExecutionDetailService.updateStacktrace(taskExecutionDetail);
    }

    @Override
    public int getOrder() {
        return 1;
    }
}

