/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.task.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.mybatis.util.SqlMapper;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ParameterConfig;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.task.dto.TaskDetail;
import com.hand.hap.task.info.TaskDataInfo;
import com.hand.hap.task.service.ITaskDetailService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/task/detail", "/api/sys/task/detail"})
public class TaskDetailController
extends BaseController {
    private final Logger logger = LoggerFactory.getLogger(TaskDetailController.class);
    private static final String UPPER_VALUE = "VALUE";
    private static final String LOWER_VALUE = "value";
    private static final String UPPER_TEXT = "TEXT";
    private static final String LOWER_TEXT = "text";
    @Autowired
    private ITaskDetailService service;
    @Autowired
    @Qualifier(value="sqlSessionFactory")
    private SqlSessionFactory sqlSessionFactory;

    @RequestMapping(value={"/query"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseData query(TaskDetail dto, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pageSize, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.service.select(requestContext, dto, page, pageSize));
    }

    @PostMapping(value={"/submit"})
    public ResponseData update(@RequestBody List<TaskDetail> dto, BindingResult result, HttpServletRequest request) {
        this.getValidator().validate(dto, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        IRequest iRequest = this.createRequestContext(request);
        return new ResponseData(this.service.batchUpdate(iRequest, dto));
    }

    @PostMapping(value={"/remove"})
    public ResponseData delete(HttpServletRequest request, @RequestBody List<TaskDetail> dto) {
        this.service.remove(dto);
        return new ResponseData();
    }

    @PostMapping(value={"/getById"})
    public ResponseData getById(HttpServletRequest request, @RequestBody TaskDetail dto) {
        IRequest iRequest = this.createRequestContext(request);
        return new ResponseData(Arrays.asList(this.service.selectByPrimaryKey(iRequest, dto)));
    }

    @PostMapping(value={"/getGroupById"})
    public ResponseData getGroupById(HttpServletRequest request, @RequestBody TaskDetail dto) {
        IRequest iRequest = this.createRequestContext(request);
        TaskDetail group = this.service.getGroupById(iRequest, dto);
        return new ResponseData(Arrays.asList(group));
    }

    @PostMapping(value={"/selectUnboundTasks"})
    public ResponseData queryUnboundTasks(TaskDetail dto, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pageSize, HttpServletRequest request) {
        IRequest iRequest = this.createRequestContext(request);
        ArrayList<String> idList = new ArrayList();
        if (dto.getIds() != null) {
            idList = Arrays.asList(dto.getIds().split(","));
        }
        return new ResponseData(this.service.queryUnboundTasks(iRequest, dto, idList, page, pageSize));
    }

    @PostMapping(value={"/executeQuery"})
    public ResponseData executeQuery(TaskDetail taskDetail, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pageSize, HttpServletRequest request) {
        IRequest iRequest = this.createRequestContext(request);
        return new ResponseData(this.service.executeQuery(iRequest, taskDetail, page, pageSize));
    }

    @PostMapping(value={"/execute"})
    public ResponseData execute(@RequestBody TaskDataInfo taskDataInfo, HttpServletRequest request) throws Exception {
        IRequest iRequest = this.createRequestContext(request);
        return new ResponseData(this.service.execute(iRequest, taskDataInfo));
    }

    @PostMapping(value={"/updateChildrenTasks"})
    public ResponseData updateChildrenTasks(@RequestBody TaskDetail data, HttpServletRequest request) {
        IRequest iRequest = this.createRequestContext(request);
        this.service.updateChildrenTasks(iRequest, data);
        return new ResponseData();
    }

    @PostMapping(value={"/detail"})
    public ResponseData detailByTId(@RequestBody TaskDetail taskDetail, HttpServletRequest request) throws Exception {
        IRequest iRequest = this.createRequestContext(request);
        List<TaskDetail> list = this.service.queryTaskDetail(iRequest, taskDetail);
        for (TaskDetail task : list) {
            this.parseParameter(iRequest, task.getParameterConfigs());
        }
        return new ResponseData(list);
    }

    private void parseParameter(IRequest request, List<ParameterConfig> parameterConfigs) {
        if (CollectionUtils.isNotEmpty(parameterConfigs)) {
            for (ParameterConfig parameterConfig : parameterConfigs) {
                if ("sql".equalsIgnoreCase(parameterConfig.getDefaultType()) && StringUtils.isNotEmpty((CharSequence)parameterConfig.getDefaultValue())) {
                    try {
                        SqlSession sqlSession = this.sqlSessionFactory.openSession();
                        Throwable throwable = null;
                        try {
                            Map<String, String> result = this.getValueAndText(request, sqlSession, parameterConfig.getDefaultValue());
                            parameterConfig.setDefaultText(result.get("defaultText"));
                            parameterConfig.setDefaultValue(result.get("defaultValue"));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (sqlSession == null) continue;
                            if (throwable != null) {
                                try {
                                    sqlSession.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            sqlSession.close();
                        }
                    }
                    catch (Throwable e) {
                        if (!this.logger.isErrorEnabled()) continue;
                        this.logger.error(e.getMessage(), e);
                        this.logger.error("\u53c2\u6570[" + parameterConfig.getTableFieldName() + "]  \u9ed8\u8ba4\u503csql\u51fa\u9519:<br><br>" + e.getMessage());
                    }
                    continue;
                }
                if (!"currentDate".equalsIgnoreCase(parameterConfig.getDefaultType())) continue;
                Date today = new Date();
                parameterConfig.setDefaultValue(new SimpleDateFormat("yyyy-MM-dd").format(today));
            }
        }
    }

    private Map<String, String> getValueAndText(IRequest request, SqlSession sqlSession, String sql) {
        HashMap<String, String> result = new HashMap<String, String>(2);
        SqlMapper sqlMapper = new SqlMapper(sqlSession);
        List<HashMap> results = sqlMapper.selectList("<script>\n\t" + sql + "</script>", request, HashMap.class);
        String defaultValue = "";
        String defaultText = "";
        if (results.size() == 1) {
            defaultValue = this.getValue(results.get(0));
            defaultText = this.getText(results.get(0));
        } else if (results.size() > 1) {
            for (HashMap map : results) {
                defaultValue = defaultValue + this.getValue(map) + ",";
            }
        }
        result.put("defaultValue", defaultValue);
        result.put("defaultText", defaultText);
        return result;
    }

    private String getValue(HashMap map) {
        if (null == map.get(UPPER_VALUE) && null == map.get(LOWER_VALUE)) {
            return "";
        }
        if (map.get(UPPER_VALUE) != null) {
            return map.get(UPPER_VALUE).toString();
        }
        if (map.get(LOWER_VALUE) != null) {
            return map.get(LOWER_VALUE).toString();
        }
        return "";
    }

    private String getText(HashMap map) {
        if (null == map.get(UPPER_TEXT) && null == map.get(LOWER_TEXT)) {
            return "";
        }
        if (map.get(UPPER_TEXT) != null) {
            return map.get(UPPER_TEXT).toString();
        }
        if (map.get(LOWER_TEXT) != null) {
            return map.get(LOWER_TEXT).toString();
        }
        return "";
    }
}

