/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.system.service.impl;

import com.hand.hap.cache.CacheSet;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.annotation.StdWho;
import com.hand.hap.message.IMessagePublisher;
import com.hand.hap.system.dto.GlobalProfile;
import com.hand.hap.system.dto.SysConfig;
import com.hand.hap.system.mapper.SysConfigMapper;
import com.hand.hap.system.service.ISysConfigService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.Date;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysConfigServiceImpl
extends BaseServiceImpl<SysConfig>
implements ISysConfigService {
    @Autowired
    private SysConfigMapper configMapper;
    @Autowired
    private IMessagePublisher messagePublisher;

    @Override
    @CacheSet(cache="config")
    public SysConfig insertSelective(IRequest request, @StdWho SysConfig config) {
        super.insertSelective(request, config);
        this.messagePublisher.publish("config", new GlobalProfile(config.getConfigCode(), config.getConfigValue()));
        return config;
    }

    @Override
    @CacheSet(cache="config")
    public SysConfig updateByPrimaryKeySelective(IRequest request, @StdWho SysConfig config) {
        super.updateByPrimaryKeySelective(request, config);
        this.messagePublisher.publish("config", new GlobalProfile(config.getConfigCode(), config.getConfigValue()));
        return config;
    }

    @Override
    public String getConfigValue(String configCode) {
        SysConfig config = this.configMapper.selectByCode(configCode);
        if (config != null) {
            return config.getConfigValue();
        }
        return null;
    }

    @Override
    public String updateSystemImageVersion(String type) {
        String tag = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss");
        this.messagePublisher.publish("config", new GlobalProfile(type, tag));
        return tag;
    }
}

