/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.system.service.impl;

import com.hand.hap.cache.CacheDelete;
import com.hand.hap.cache.CacheSet;
import com.hand.hap.cache.impl.HashStringRedisCache;
import com.hand.hap.cache.impl.HashStringRedisCacheGroup;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.annotation.StdWho;
import com.hand.hap.message.IMessagePublisher;
import com.hand.hap.mybatis.common.Criteria;
import com.hand.hap.system.dto.Prompt;
import com.hand.hap.system.service.IPromptService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class PromptServiceImpl
extends BaseServiceImpl<Prompt>
implements IPromptService {
    @Autowired
    private IMessagePublisher messagePublisher;
    @Autowired
    @Qualifier(value="promptCache")
    private HashStringRedisCacheGroup<String> promptCache;

    @Override
    public List<Prompt> submit(IRequest request, List<Prompt> list) {
        ((IPromptService)this.self()).batchUpdate(request, list);
        for (Prompt prompt : list) {
            this.notifyCache(prompt);
            this.notifyPromptCache(prompt);
        }
        return list;
    }

    @Override
    public String getPromptDescription(String locale, String promptCode) {
        String description = (String)((HashStringRedisCache)this.promptCache.getGroup(locale)).getValue(promptCode);
        if (description == null) {
            Prompt prompt = new Prompt();
            prompt.setLang(locale);
            prompt.setPromptCode(promptCode);
            Criteria criteria = new Criteria(prompt);
            criteria.where("lang", "promptCode");
            criteria.select("description");
            List<Prompt> prompts = super.selectOptions(null, prompt, criteria);
            if (CollectionUtils.isNotEmpty(prompts)) {
                description = prompts.get(0).getDescription();
                ((HashStringRedisCache)this.promptCache.getGroup(locale)).setValue(promptCode, description);
            }
        }
        return description;
    }

    @Override
    @CacheSet(cache="prompt")
    public Prompt insertSelective(IRequest request, @StdWho Prompt prompt) {
        super.insertSelective(request, prompt);
        return prompt;
    }

    @Override
    @CacheDelete(cache="prompt")
    public int deleteByPrimaryKey(Prompt prompt) {
        return super.deleteByPrimaryKey(prompt);
    }

    @Override
    @CacheSet(cache="prompt")
    public Prompt updateByPrimaryKeySelective(IRequest request, @StdWho Prompt prompt) {
        return super.updateByPrimaryKeySelective(request, prompt);
    }

    @Override
    @CacheSet(cache="prompt")
    public Prompt updateByPrimaryKey(IRequest request, Prompt prompt) {
        return super.updateByPrimaryKey(request, prompt);
    }

    private void notifyCache(Prompt prompt) {
        this.messagePublisher.publish("cache.prompt", prompt.getPromptCode());
    }

    private void notifyPromptCache(Prompt prompt) {
        this.messagePublisher.publish("cache.prompt.all", prompt);
    }
}

