/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.security.service.impl;

import com.hand.hap.account.dto.User;
import com.hand.hap.account.service.IUserService;
import com.hand.hap.security.CheckUserUtil;
import com.hand.hap.security.CustomUserDetails;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service
public class CustomUserDetailsService
implements UserDetailsService {
    @Autowired
    private IUserService userService;

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        User user = this.userService.selectByUserName(username);
        if (user == null) {
            throw new UsernameNotFoundException("User not found:" + username);
        }
        CheckUserUtil.checkUserException(user);
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        authorities.add(new SimpleGrantedAuthority("ROLE_USER"));
        for (String role : user.getRoleCode()) {
            authorities.add(new SimpleGrantedAuthority(role));
        }
        CustomUserDetails userDetails = new CustomUserDetails(user.getUserId(), user.getUserName(), user.getPasswordEncrypted(), true, true, true, true, authorities, user.getEmployeeId(), user.getEmployeeCode());
        return userDetails;
    }
}

