/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.security.permission.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.security.permission.dto.DataPermissionTable;
import com.hand.hap.security.permission.service.IDataPermissionTableService;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/data/permission/table", "/api/sys/data/permission/table"})
public class DataPermissionTableController
extends BaseController {
    @Autowired
    private IDataPermissionTableService service;

    @RequestMapping(value={"/query"})
    public ResponseData query(DataPermissionTable dto, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pageSize, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.service.select(requestContext, dto, page, pageSize));
    }

    @PostMapping(value={"/submit"})
    public ResponseData update(@RequestBody List<DataPermissionTable> dto, BindingResult result, HttpServletRequest request) {
        this.getValidator().validate(dto, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        IRequest requestCtx = this.createRequestContext(request);
        return new ResponseData(this.service.batchUpdate(requestCtx, dto));
    }

    @PostMapping(value={"/remove"})
    public ResponseData delete(HttpServletRequest request, @RequestBody List<DataPermissionTable> dto) {
        this.service.removeTableWithRule(dto);
        return new ResponseData();
    }
}

