/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hand.hap.security.oauth.dto.Oauth2ClientDetails;
import com.hand.hap.security.oauth.service.IOauth2ClientDetailsService;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.ClientRegistrationException;
import org.springframework.security.oauth2.provider.NoSuchClientException;
import org.springframework.security.oauth2.provider.client.BaseClientDetails;
import org.springframework.util.StringUtils;

public class CustomJdbcClientDetailsService
implements ClientDetailsService {
    private static final Logger logger = LoggerFactory.getLogger(CustomJdbcClientDetailsService.class);
    public static final String DEFAULT_CLIENT_ID = "HAP_INNER_CLIENT_ID";
    public static final String DEFAULT_CLIENT_SECRET = "2d6be1aa-5e3b-4b03-b8c9-d553ea276a05";
    private static final String DEFAULT_SCOPE = "default";
    private static final String DEFAULT_RESOURCE_ID = "api-resource";
    private static final String DEFAULT_AUTHORIZED_GRANT_TYPES = "password,refresh_token";
    private static final String DEFAULT_AUTHORITIES = "authorities";
    private static final ThreadLocal<ClientDetails> CLIENT_DETAILS = new ThreadLocal();
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private IOauth2ClientDetailsService clientDetailsService;

    public ClientDetails loadInnerClient() {
        BaseClientDetails baseClientDetails = new BaseClientDetails(DEFAULT_CLIENT_ID, DEFAULT_RESOURCE_ID, DEFAULT_SCOPE, DEFAULT_AUTHORIZED_GRANT_TYPES, DEFAULT_AUTHORITIES, null);
        baseClientDetails.setClientSecret(DEFAULT_CLIENT_SECRET);
        baseClientDetails.setAccessTokenValiditySeconds(Integer.valueOf(86400));
        return baseClientDetails;
    }

    public ClientDetails loadClientByClientId(String clientId) throws ClientRegistrationException {
        if (DEFAULT_CLIENT_ID.equalsIgnoreCase(clientId)) {
            return this.loadInnerClient();
        }
        Oauth2ClientDetails oauth2ClientDetails = this.clientDetailsService.selectByClientId(clientId);
        if (oauth2ClientDetails == null) {
            throw new NoSuchClientException("No client with requested id: " + clientId);
        }
        BaseClientDetails details = new BaseClientDetails(oauth2ClientDetails.getClientId(), oauth2ClientDetails.getResourceIds(), oauth2ClientDetails.getScope(), oauth2ClientDetails.getAuthorizedGrantTypes(), oauth2ClientDetails.getAuthorities(), oauth2ClientDetails.getRedirectUri());
        details.setAutoApproveScopes((Collection)StringUtils.commaDelimitedListToSet((String)oauth2ClientDetails.getAutoApprove()));
        details.setClientSecret(oauth2ClientDetails.getClientSecret());
        if (oauth2ClientDetails.getRefreshTokenValidity() != null) {
            details.setRefreshTokenValiditySeconds(Integer.valueOf(oauth2ClientDetails.getRefreshTokenValidity().intValue()));
        }
        if (oauth2ClientDetails.getAccessTokenValidity() != null) {
            details.setAccessTokenValiditySeconds(Integer.valueOf(oauth2ClientDetails.getAccessTokenValidity().intValue()));
        }
        if (oauth2ClientDetails.getAdditionalInformation() != null) {
            try {
                Map additionalInformation = (Map)this.objectMapper.readValue(oauth2ClientDetails.getAdditionalInformation(), Map.class);
                details.setAdditionalInformation(additionalInformation);
            }
            catch (Exception e) {
                logger.warn("Could not decode JSON for additional information: " + details, (Throwable)e);
            }
        }
        return details;
    }

    public static void clearInfo() {
        if (CLIENT_DETAILS != null) {
            CLIENT_DETAILS.remove();
        }
    }
}

