/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.security;

import com.hand.hap.account.dto.User;
import com.hand.hap.account.exception.UserException;
import org.springframework.security.authentication.LockedException;

public final class CheckUserUtil {
    public static void checkUserException(User user) {
        UserException userException = null;
        if ("LOCK".equalsIgnoreCase(user.getStatus())) {
            userException = new UserException("error.user.account_locked", null);
        } else if ("EXPR".equalsIgnoreCase(user.getStatus())) {
            userException = new UserException("error.user.account_expired", null);
        } else if (user.getStartActiveDate() != null && user.getStartActiveDate().getTime() > System.currentTimeMillis()) {
            userException = new UserException("error.user.account_not_active", null);
        } else if (user.getEndActiveDate() != null && user.getEndActiveDate().getTime() < System.currentTimeMillis()) {
            userException = new UserException("error.user.account_expired", null);
        }
        if (userException != null) {
            throw new LockedException(userException.getMessage(), (Throwable)userException);
        }
    }
}

