/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.metrics;

import com.codahale.metrics.Timer;
import com.hand.hap.metrics.MetricsConfigurationBean;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class MetricAspect {
    @Autowired
    MetricsConfigurationBean metricsConfigurationBean;
    private Timer.Context context = null;
    private static final Logger logger = LoggerFactory.getLogger(MetricAspect.class);

    @Pointcut(value="@annotation(com.codahale.metrics.annotation.Timed)")
    public void timedAspect() {
    }

    @Before(value="timedAspect()")
    public void doBefore(JoinPoint joinPoint) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        this.context = this.metricsConfigurationBean.getMetricRegistry().timer(request.getRequestURI()).time();
    }

    @After(value="timedAspect()")
    public void doAfter(JoinPoint joinPoint) {
        this.context.stop();
    }
}

