/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.message.impl.rabbitmq;

import com.hand.hap.message.MethodReflectUtils;
import com.hand.hap.message.QueueMonitor;
import com.hand.hap.message.TopicMonitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.adapter.MessageListenerAdapter;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.SmartLifecycle;

public class ListenerContainerFactory
implements ApplicationContextAware,
SmartLifecycle {
    private Logger logger = LoggerFactory.getLogger(ListenerContainerFactory.class);
    private volatile boolean running = false;
    private static final int PHASE = 9999;
    private ApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="defaultRabbitAdmin")
    private RabbitAdmin rabbitAdmin;
    @Autowired
    @Qualifier(value="defaultDirectExchange")
    private DirectExchange directExchange;
    @Autowired
    @Qualifier(value="defaultTopicExchange")
    private TopicExchange topicExchange;
    @Autowired
    @Qualifier(value="defaultConnectionFactory")
    private ConnectionFactory connectionFactory;
    @Autowired
    private Jackson2JsonMessageConverter jackson2JsonMessageConverter;
    private List<SimpleMessageListenerContainer> listenerContainerList = new ArrayList<SimpleMessageListenerContainer>();

    public void start() {
        if (!this.isRunning()) {
            Map queueMonitors = this.applicationContext.getBeansWithAnnotation(QueueMonitor.class);
            queueMonitors.forEach((k, v) -> {
                Class<?> clazz = v.getClass();
                QueueMonitor qm = clazz.getAnnotation(QueueMonitor.class);
                String queueName = qm.queue();
                Queue queue = new Queue(k + "-" + queueName, true);
                this.rabbitAdmin.declareQueue(queue);
                this.rabbitAdmin.declareBinding(BindingBuilder.bind((Queue)queue).to(this.directExchange).with(queueName));
                SimpleMessageListenerContainer container = new SimpleMessageListenerContainer(this.connectionFactory);
                this.listenerContainerList.add(container);
                String mn = MethodReflectUtils.getQueueMethodName(qm.method(), v);
                CustomMessageListenerAdapter adapter = new CustomMessageListenerAdapter(v, mn, this.jackson2JsonMessageConverter);
                container.setRabbitAdmin(this.rabbitAdmin);
                container.setMessageListener((Object)adapter);
                container.setQueueNames(new String[]{queue.getName()});
                container.start();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Start message listener {} on {}", (Object)(k + "." + mn), (Object)queue.getName());
                }
            });
            Map topicMonitors = this.applicationContext.getBeansWithAnnotation(TopicMonitor.class);
            topicMonitors.forEach((k, v) -> {
                Class<?> clazz = v.getClass();
                TopicMonitor qm = clazz.getAnnotation(TopicMonitor.class);
                String[] channelNames = qm.channel();
                Queue queue = this.rabbitAdmin.declareQueue();
                SimpleMessageListenerContainer container = new SimpleMessageListenerContainer(this.connectionFactory);
                this.listenerContainerList.add(container);
                for (String channelName : channelNames) {
                    this.rabbitAdmin.declareBinding(BindingBuilder.bind((Queue)queue).to(this.topicExchange).with(channelName));
                }
                String tmn = MethodReflectUtils.getTopicMethodName(qm.method(), v);
                CustomMessageListenerAdapter adapter = new CustomMessageListenerAdapter(v, tmn, this.jackson2JsonMessageConverter);
                container.setRabbitAdmin(this.rabbitAdmin);
                container.setMessageListener((Object)adapter);
                container.setQueueNames(new String[]{queue.getName()});
                container.start();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Start topic listener {} on {}", (Object)(k + "." + tmn), (Object)queue.getName());
                }
            });
            this.running = true;
        }
    }

    public void stop() {
        this.stop(null);
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        if (this.isRunning()) {
            this.listenerContainerList.forEach(c -> c.stop());
            this.running = false;
        }
        if (callback != null) {
            callback.run();
        }
    }

    public int getPhase() {
        return 9999;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private static class CustomMessageListenerAdapter
    extends MessageListenerAdapter {
        public CustomMessageListenerAdapter(Object delegate, String defaultListenerMethod, Jackson2JsonMessageConverter jackson2JsonMessageConverter) {
            super(delegate, defaultListenerMethod);
            this.setMessageConverter((MessageConverter)jackson2JsonMessageConverter);
        }

        protected Object invokeListenerMethod(String methodName, Object[] arguments, Message originalMessage) throws Exception {
            arguments = new Object[]{arguments[0], originalMessage.getMessageProperties().getReceivedRoutingKey()};
            return super.invokeListenerMethod(methodName, arguments, originalMessage);
        }
    }
}

