/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.mail.service.impl;

import com.github.pagehelper.PageHelper;
import com.hand.hap.cache.impl.MessageTemplateCache;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.exception.EmailException;
import com.hand.hap.core.impl.RequestHelper;
import com.hand.hap.mail.MessageTypeEnum;
import com.hand.hap.mail.PriorityLevelEnum;
import com.hand.hap.mail.SendTypeEnum;
import com.hand.hap.mail.dto.Message;
import com.hand.hap.mail.dto.MessageAttachment;
import com.hand.hap.mail.dto.MessageEmailAccount;
import com.hand.hap.mail.dto.MessageReceiver;
import com.hand.hap.mail.dto.MessageTemplate;
import com.hand.hap.mail.mapper.MessageAttachmentMapper;
import com.hand.hap.mail.mapper.MessageEmailAccountMapper;
import com.hand.hap.mail.mapper.MessageMapper;
import com.hand.hap.mail.mapper.MessageReceiverMapper;
import com.hand.hap.mail.mapper.MessageTemplateMapper;
import com.hand.hap.mail.service.IEmailService;
import com.hand.hap.mail.service.IMessageService;
import com.hand.hap.message.IMessagePublisher;
import com.hand.hap.system.dto.BaseDTO;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MessageServiceImpl
implements IMessageService {
    private static final String MSG_NO_MESSAGE_RECEIVER = "msg.warning.system.no_message_receiver";
    private static final String MSG_NO_MESSAGE_TEMPLATE = "msg.warning.system.no_message_template";
    private static final String MSG_MESSAGE_TYPE_EMPTY = "msg.warning.system.email_message_type_empty";
    private static final String MSG_MESSAGE_PRIORITY_EMPTY = "msg.warning.system.email_message_priority_empty";
    private static final String MSG_MESSAGE_SEND_TYPE_EMPTY = "msg.warning.system.message_send_type_empty";
    private static final String MSG_MESSAGE_ACCOUNT_EMPTY = "msg.warning.system.message_account_empty";
    private static final String MSG_MESSAGE_CONFIG_NONEXISTENT = "msg.warning.system.message_config_nonexistent";
    private static final String MSG_MESSAGE_CONFIG_DISABLE = "msg.warning.system.message_config_disable";
    private static final String PRIORITY_VIP = "vip";
    @Autowired
    private MessageMapper messageMapper;
    @Autowired
    private MessageAttachmentMapper attachmentMapper;
    @Autowired
    private MessageReceiverMapper receiverMapper;
    @Autowired
    private MessageTemplateMapper templateMapper;
    @Autowired
    private MessageEmailAccountMapper emailAccountMapper;
    @Autowired
    private IMessagePublisher messagePublisher;
    @Autowired
    private IEmailService emailService;
    @Autowired
    private MessageTemplateCache templateCache;

    @Override
    public Message sendMessage(IRequest iRequest, String templateCode, Map<String, Object> templateData, List<MessageReceiver> receivers, List<Long> attachmentIds) throws Exception {
        if (CollectionUtils.isEmpty(receivers)) {
            throw new EmailException(MSG_NO_MESSAGE_RECEIVER);
        }
        MessageTemplate template = null;
        template = this.templateCache.getValue(templateCode);
        if (null == template) {
            template = this.templateMapper.selectByCode(templateCode);
        }
        this.validateMessageTemplate(template);
        MessageEmailAccount account = (MessageEmailAccount)this.emailAccountMapper.selectByPrimaryKey(template.getAccountId());
        String accountCode = null;
        if (account != null) {
            accountCode = account.getAccountCode();
        }
        String subject = this.translateData(template.getSubject(), templateData);
        String content = this.translateData(template.getContent(), templateData);
        String messageType = template.getTemplateType();
        String sendType = template.getSendType();
        this.sendMessage(iRequest, accountCode, subject, content, messageType, sendType, templateCode, receivers, attachmentIds);
        return null;
    }

    @Override
    public Message sendMessage(IRequest iRequest, String accountCode, String subject, String content, String messageType, String sendType, String messageSource, List<MessageReceiver> receivers, List<Long> attachmentIds) throws Exception {
        this.validateMessageCustom(receivers, accountCode, messageType, sendType);
        if (MessageTypeEnum.EMAIL.getCode().equalsIgnoreCase(messageType)) {
            MessageEmailAccount emailAccount = new MessageEmailAccount();
            emailAccount.setAccountCode(accountCode);
            String messageEmailConfig = this.emailAccountMapper.selectMessageEmailConfig(emailAccount);
            if (StringUtils.isEmpty((CharSequence)messageEmailConfig)) {
                throw new EmailException(MSG_MESSAGE_CONFIG_NONEXISTENT);
            }
            if ("N".equals(messageEmailConfig)) {
                throw new EmailException(MSG_MESSAGE_CONFIG_DISABLE);
            }
            MessageEmailAccount account = this.emailAccountMapper.selectByAccountCode(accountCode);
            Message message = new Message();
            message.setMessageType(messageType);
            if (SendTypeEnum.DIRECT.getCode().equalsIgnoreCase(sendType)) {
                message.setSendFlag("P");
            }
            message.setSubject(subject);
            message.setContent(content);
            message.setMessageFrom(account.getAccountCode());
            message.setMessageSource(messageSource);
            ((IMessageService)this.self()).insertData(iRequest, message, receivers, attachmentIds);
            if (SendTypeEnum.DIRECT.getCode().equalsIgnoreCase(sendType)) {
                this.emailService.sendSingleEmailMessage(message, null);
            }
        }
        return null;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, noRollbackFor={Exception.class})
    public void insertData(IRequest iRequest, Message message, List<MessageReceiver> receivers, List<Long> attachmentIds) {
        this.initStd(message, iRequest);
        this.messageMapper.insertSelective(message);
        if (CollectionUtils.isNotEmpty(attachmentIds)) {
            for (Long l : attachmentIds) {
                MessageAttachment attachment = new MessageAttachment();
                attachment.setFileId(l);
                attachment.setMessageId(message.getMessageId());
                this.initStd(attachment, iRequest);
                this.attachmentMapper.insertSelective(attachment);
            }
        }
        for (MessageReceiver messageReceiver : receivers) {
            messageReceiver.setMessageId(message.getMessageId());
            this.initStd(messageReceiver, iRequest);
            this.receiverMapper.insertSelective(messageReceiver);
        }
    }

    @Override
    public List<Message> selectMessagesBySubject(IRequest requestContext, Message message, int page, int pagesize) {
        PageHelper.startPage(page, pagesize);
        return this.messageMapper.selectMessagesBySubject(message);
    }

    @Override
    public List<Message> selectMessages(IRequest requestContext, Message message, int page, int pagesize) {
        PageHelper.startPage(page, pagesize);
        return this.messageMapper.selectMessages(message);
    }

    @Override
    public Message selectMessageContent(IRequest requestContext, Message message) {
        return this.messageMapper.selectMessageContent(message);
    }

    @Override
    public List<MessageReceiver> selectMessageAddressesByMessageId(IRequest requestContext, MessageReceiver messageReceiver, int page, int pagesize) {
        PageHelper.startPage(page, pagesize);
        return this.receiverMapper.selectMessageAddressesByMessageId(messageReceiver);
    }

    @Override
    public Message addEmailMessage(Long userId, String accountCode, String templateCode, Map<String, Object> data, List<Long> attachmentIds, List<MessageReceiver> receivers) throws Exception {
        MessageTemplate template = this.templateMapper.selectByCode(templateCode);
        if (template == null) {
            throw new EmailException(MSG_NO_MESSAGE_TEMPLATE);
        }
        if (template.getPriorityLevel() == null) {
            throw new EmailException(MSG_MESSAGE_PRIORITY_EMPTY);
        }
        Message message = ((IMessageService)this.self()).sendEmailMessage(userId, null, templateCode, accountCode, data, receivers, attachmentIds);
        if (PRIORITY_VIP.equals(template.getPriorityLevel())) {
            this.messagePublisher.message("hap:queue:email:vip", message);
        } else {
            this.messagePublisher.message("hap:queue:email:normal", message);
        }
        return message;
    }

    @Override
    public Message addEmailMessage(Long userId, String accountCode, String subject, String content, PriorityLevelEnum priority, List<Long> attachmentIds, List<MessageReceiver> receivers) throws Exception {
        Message message = ((IMessageService)this.self()).sendEmailMessage(userId, null, accountCode, subject, content, priority, receivers, attachmentIds);
        if (PRIORITY_VIP.equals(priority.getCode())) {
            this.messagePublisher.message("hap:queue:email:vip", message);
        } else {
            this.messagePublisher.message("hap:queue:email:normal", message);
        }
        return message;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Message sendEmailMessage(Long sender, Long marketId, String templateCode, String emailAccountCode, Map<String, Object> data, List<MessageReceiver> receivers, List<Long> attachmentIds) throws Exception {
        MessageTemplate template = this.check(templateCode, emailAccountCode, receivers);
        String subject = this.translateData(template.getSubject(), data);
        String content = this.translateData(template.getContent(), data);
        String priorityS = template.getPriorityLevel();
        PriorityLevelEnum priority = PriorityLevelEnum.valueOf(priorityS);
        Message sendSmsMessage = this.sendEmailMessage(sender, marketId, emailAccountCode, subject, content, priority, receivers, attachmentIds);
        return sendSmsMessage;
    }

    public static String from(Long marketId, String accountCode) {
        StringBuilder sb = new StringBuilder();
        sb.append("I");
        sb.append(marketId);
        sb.append("://");
        sb.append(accountCode);
        return sb.toString();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Message sendEmailMessage(Long sender, Long marketId, String emailAccountCode, String subject, String content, PriorityLevelEnum priority, List<MessageReceiver> receivers, List<Long> attachmentIds) throws Exception {
        this.check(emailAccountCode, priority, receivers);
        MessageEmailAccount emailAccount = new MessageEmailAccount();
        emailAccount.setAccountCode(emailAccountCode);
        String messageEmailConfig = this.emailAccountMapper.selectMessageEmailConfig(emailAccount);
        if (StringUtils.isEmpty((CharSequence)messageEmailConfig)) {
            throw new EmailException(MSG_MESSAGE_CONFIG_NONEXISTENT);
        }
        if ("N".equals(messageEmailConfig)) {
            throw new EmailException(MSG_MESSAGE_CONFIG_DISABLE);
        }
        MessageEmailAccount account = this.emailAccountMapper.selectByAccountCode(emailAccountCode);
        Message message = new Message();
        message.setMessageType(MessageTypeEnum.EMAIL.getCode());
        message.setPriorityLevel(priority.getCode());
        message.setSubject(subject);
        message.setContent(content);
        message.setSendFlag("N");
        if (null == marketId) {
            message.setMessageFrom(account.getAccountCode());
        } else {
            message.setMessageFrom(MessageServiceImpl.from(marketId, account.getAccountCode()));
        }
        IRequest iRequest = RequestHelper.newEmptyRequest();
        iRequest.setUserId(sender);
        this.initStd(message, iRequest);
        this.messageMapper.insertSelective(message);
        if (attachmentIds != null && attachmentIds.size() > 0) {
            for (Long l : attachmentIds) {
                MessageAttachment attachment = new MessageAttachment();
                attachment.setMessageId(message.getMessageId());
                attachment.setFileId(l);
                this.initStd(attachment, iRequest);
                this.attachmentMapper.insertSelective(attachment);
            }
        }
        for (MessageReceiver messageReceiver : receivers) {
            messageReceiver.setMessageId(message.getMessageId());
            this.initStd(messageReceiver, iRequest);
            this.receiverMapper.insertSelective(messageReceiver);
        }
        return message;
    }

    private void validateMessageTemplate(MessageTemplate template) throws EmailException {
        if (null == template) {
            throw new EmailException(MSG_NO_MESSAGE_TEMPLATE);
        }
        if (StringUtils.isEmpty((CharSequence)template.getTemplateType())) {
            throw new EmailException(MSG_MESSAGE_TYPE_EMPTY);
        }
        if (MessageTypeEnum.EMAIL.getCode().equalsIgnoreCase(template.getTemplateType())) {
            if (StringUtils.isEmpty((CharSequence)template.getSendType())) {
                throw new EmailException(MSG_MESSAGE_SEND_TYPE_EMPTY);
            }
            if (null == template.getAccountId()) {
                throw new EmailException(MSG_MESSAGE_ACCOUNT_EMPTY);
            }
        }
    }

    private void validateMessageCustom(List<MessageReceiver> receivers, String accountCode, String messageType, String sendType) throws EmailException {
        if (CollectionUtils.isEmpty(receivers)) {
            throw new EmailException(MSG_NO_MESSAGE_RECEIVER);
        }
        if (StringUtils.isEmpty((CharSequence)messageType)) {
            throw new EmailException(MSG_MESSAGE_TYPE_EMPTY);
        }
        if (MessageTypeEnum.EMAIL.getCode().equalsIgnoreCase(messageType)) {
            if (StringUtils.isEmpty((CharSequence)sendType)) {
                throw new EmailException(MSG_MESSAGE_SEND_TYPE_EMPTY);
            }
            if (StringUtils.isEmpty((CharSequence)accountCode)) {
                throw new EmailException(MSG_MESSAGE_ACCOUNT_EMPTY);
            }
        }
    }

    private String translateData(String content, Map data) throws Exception {
        if (content == null) {
            return "";
        }
        try (StringWriter out = new StringWriter();){
            Configuration config = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
            config.setDefaultEncoding("UTF-8");
            config.setClassicCompatible(true);
            Template template = new Template(null, content, config);
            template.process((Object)data, (Writer)out);
            String string = out.toString();
            return string;
        }
    }

    private void initStd(BaseDTO dto, IRequest iRequest) {
        dto.setObjectVersionNumber(1L);
        dto.setCreationDate(new Date());
        dto.setLastUpdateDate(new Date());
        if (iRequest != null) {
            dto.setCreatedBy(iRequest.getUserId());
            dto.setLastUpdatedBy(iRequest.getUserId());
        } else {
            dto.setCreatedBy(null);
            dto.setLastUpdatedBy(null);
        }
    }

    private MessageTemplate check(String templateCode, String accountCode, List<MessageReceiver> receivers) throws EmailException {
        if (CollectionUtils.isEmpty(receivers)) {
            throw new EmailException(MSG_NO_MESSAGE_RECEIVER);
        }
        MessageTemplate record = new MessageTemplate();
        record.setTemplateCode(templateCode);
        List<MessageTemplate> selectMessageTemplates = this.templateMapper.select(record);
        if (CollectionUtils.isEmpty(selectMessageTemplates)) {
            throw new EmailException(MSG_NO_MESSAGE_TEMPLATE);
        }
        MessageTemplate template = selectMessageTemplates.get(0);
        if (template == null) {
            throw new EmailException(MSG_NO_MESSAGE_TEMPLATE);
        }
        if (template.getPriorityLevel() == null) {
            throw new EmailException(MSG_MESSAGE_PRIORITY_EMPTY);
        }
        if (accountCode == null) {
            throw new EmailException(MSG_MESSAGE_ACCOUNT_EMPTY);
        }
        return template;
    }

    private void check(String accountCode, PriorityLevelEnum priority, List<MessageReceiver> receivers) throws EmailException {
        if (CollectionUtils.isEmpty(receivers)) {
            throw new EmailException(MSG_NO_MESSAGE_RECEIVER);
        }
        if (priority == null) {
            throw new EmailException(MSG_MESSAGE_PRIORITY_EMPTY);
        }
        for (MessageReceiver messageReceiver : receivers) {
            String messageAddress = messageReceiver.getMessageAddress();
            if (messageAddress != null && !"".equals(messageAddress.trim())) continue;
            throw new EmailException(MSG_NO_MESSAGE_RECEIVER);
        }
        if (accountCode == null) {
            throw new EmailException(MSG_MESSAGE_ACCOUNT_EMPTY);
        }
    }
}

