/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.mail.service.impl;

import com.github.pagehelper.PageHelper;
import com.hand.hap.core.IRequest;
import com.hand.hap.mail.dto.MessageEmailAccount;
import com.hand.hap.mail.mapper.MessageEmailAccountMapper;
import com.hand.hap.mail.service.IMessageEmailAccountService;
import com.hand.hap.security.service.IAESClientService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MessageEmailAccountServiceImpl
extends BaseServiceImpl<MessageEmailAccount>
implements IMessageEmailAccountService,
BeanFactoryAware {
    private BeanFactory beanFactory;
    @Autowired
    private MessageEmailAccountMapper mapper;
    @Autowired
    private IAESClientService aceClientService;

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MessageEmailAccount createMessageEmailAccount(IRequest request, MessageEmailAccount obj) {
        if (obj == null) {
            return null;
        }
        obj.setPassword(this.aceClientService.encrypt(obj.getPassword()));
        this.mapper.insertSelective(obj);
        return obj;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MessageEmailAccount updateMessageEmailAccount(IRequest request, MessageEmailAccount obj) {
        if (obj == null) {
            return null;
        }
        obj.setPassword(null);
        int updateCount = this.mapper.updateByPrimaryKeySelective(obj);
        this.checkOvn(updateCount, obj);
        return obj;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MessageEmailAccount updateMessageEmailAccountPasswordOnly(IRequest request, MessageEmailAccount obj) {
        if (obj == null) {
            return null;
        }
        obj.setPassword(this.aceClientService.encrypt(obj.getPassword()));
        int updateCount = this.mapper.updateByPrimaryKeySelective(obj);
        this.checkOvn(updateCount, obj);
        return obj;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public MessageEmailAccount selectMessageEmailAccountById(IRequest request, Long objId) {
        if (objId == null) {
            return null;
        }
        return (MessageEmailAccount)this.mapper.selectByPrimaryKey(objId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int deleteMessageEmailAccount(IRequest request, MessageEmailAccount obj) {
        if (obj.getAccountId() == null) {
            return 0;
        }
        int updateCount = this.mapper.deleteByPrimaryKey(obj);
        this.checkOvn(updateCount, obj);
        return updateCount;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int batchDelete(IRequest request, List<MessageEmailAccount> objs) {
        int result = 0;
        if (CollectionUtils.isEmpty(objs)) {
            return result;
        }
        for (MessageEmailAccount obj : objs) {
            ((IMessageEmailAccountService)this.self()).deleteMessageEmailAccount(request, obj);
            ++result;
        }
        return result;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<MessageEmailAccount> selectMessageEmailAccounts(IRequest request, MessageEmailAccount example, int page, int pageSize) {
        PageHelper.startPage(page, pageSize);
        return this.mapper.selectMessageEmailAccounts(example);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<MessageEmailAccount> selectMessageEmailAccountWithPassword(IRequest request, MessageEmailAccount example, int page, int pageSize) {
        PageHelper.startPage(page, pageSize);
        return this.mapper.selectMessageEmailAccountPassword(example);
    }
}

