/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.mail.controllers;

import com.hand.hap.mail.dto.Message;
import com.hand.hap.mail.mapper.MessageMapper;
import com.hand.hap.mail.service.IEmailService;
import com.hand.hap.system.controllers.BaseController;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class EmailController
extends BaseController {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    IEmailService emailService;
    @Autowired
    MessageMapper messageMapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/send_all_email", "/mail/send_all_email", "/api/mail/send_all_email"})
    public boolean sendAllEmail() {
        HashedMap pa = new HashedMap();
        pa.put("batch", 0);
        pa.put("isVipQueue", false);
        boolean result = false;
        try {
            result = this.emailService.sendMessages((Map<String, Object>)pa);
            return result;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/mail/resend_email", "/api/mail/resend_email"})
    public boolean reSendEmail(@RequestBody List<Message> messages) {
        boolean result = false;
        ArrayList<Message> newMessages = new ArrayList<Message>();
        for (Message mess : messages) {
            Message s1 = (Message)this.messageMapper.selectByPrimaryKey(mess);
            if (s1 == null || !"F".equals(s1.getSendFlag())) continue;
            newMessages.add(s1);
        }
        try {
            result = this.emailService.reSendMessages(newMessages, (Map<String, Object>)new HashedMap());
            return result;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            return result;
        }
    }
}

