/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.hr.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.hr.dto.HrOrgUnit;
import com.hand.hap.hr.service.IOrgUnitService;
import com.hand.hap.mybatis.common.Criteria;
import com.hand.hap.mybatis.common.query.Comparison;
import com.hand.hap.mybatis.common.query.WhereField;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/hr/unit", "/api/hr/unit"})
public class UnitController
extends BaseController {
    @Autowired
    IOrgUnitService service;

    @RequestMapping(value={"/query"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseData query(HttpServletRequest request, HrOrgUnit unit, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize) {
        IRequest requestCtx = this.createRequestContext(request);
        Criteria criteria = new Criteria(unit);
        criteria.where(new WhereField("unitCode", Comparison.LIKE), "unitId", "parentId", "name", "unitType");
        return new ResponseData(this.service.selectOptions(requestCtx, unit, criteria, page, pagesize));
    }

    @RequestMapping(value={"/queryall"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseData queryAllUnits(HttpServletRequest request) {
        IRequest requestCtx = this.createRequestContext(request);
        Criteria criteria = new Criteria();
        criteria.select("parentName", "name", "unitCode", "description", "unitId", "parentId", "positionName");
        criteria.selectExtensionAttribute();
        HrOrgUnit unit = new HrOrgUnit();
        unit.setEnabledFlag("Y");
        return new ResponseData(this.service.selectOptions(requestCtx, unit, criteria));
    }

    @PostMapping(value={"/submit"})
    public ResponseData update(HttpServletRequest request, @RequestBody List<HrOrgUnit> units, BindingResult result) {
        this.getValidator().validate(units, (Errors)result);
        if (result.hasErrors()) {
            ResponseData rd = new ResponseData(false);
            rd.setMessage(this.getErrorMessage((Errors)result, request));
            return rd;
        }
        IRequest requestCtx = this.createRequestContext(request);
        return new ResponseData(this.service.batchUpdate(requestCtx, units));
    }

    @PostMapping(value={"/remove"})
    public ResponseData delete(HttpServletRequest request, @RequestBody List<HrOrgUnit> units) {
        this.service.batchDelete(units);
        return new ResponseData();
    }
}

