/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.function.service.impl;

import com.hand.hap.cache.impl.ResourceItemAssignCache;
import com.hand.hap.cache.impl.ResourceItemCache;
import com.hand.hap.cache.impl.ResourceItemElementCache;
import com.hand.hap.cache.impl.RoleResourceItemCache;
import com.hand.hap.core.IRequest;
import com.hand.hap.function.dto.Function;
import com.hand.hap.function.dto.MenuItem;
import com.hand.hap.function.dto.Resource;
import com.hand.hap.function.dto.ResourceItem;
import com.hand.hap.function.dto.ResourceItemAssign;
import com.hand.hap.function.dto.ResourceItemCount;
import com.hand.hap.function.dto.ResourceItemElement;
import com.hand.hap.function.dto.RoleResourceItem;
import com.hand.hap.function.mapper.FunctionMapper;
import com.hand.hap.function.mapper.ResourceItemAssignMapper;
import com.hand.hap.function.mapper.RoleResourceItemMapper;
import com.hand.hap.function.service.IRoleResourceItemService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.logstash.logback.encoder.org.apache.commons.lang.ArrayUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RoleResourceItemServiceImpl
extends BaseServiceImpl<RoleResourceItem>
implements IRoleResourceItemService {
    @Autowired
    private RoleResourceItemMapper roleResourceItemMapper;
    @Autowired
    private FunctionMapper functionMapper;
    @Autowired
    private ResourceItemCache resourceItemCache;
    @Autowired
    private RoleResourceItemCache roleResourceItemCache;
    @Autowired
    private ResourceItemAssignMapper resourceItemAssignMapper;
    @Autowired
    private ResourceItemAssignCache resourceItemAssignCache;
    @Autowired
    private ResourceItemElementCache resourceItemElementCache;

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<MenuItem> queryResourceItems(IRequest requestContext, Long roleId, Long functionId) {
        Function function = new Function();
        function.setFunctionId(functionId);
        List<Resource> resources = ((IRoleResourceItemService)this.self()).queryHtmlResources(requestContext, function);
        List<MenuItem> menus = ((IRoleResourceItemService)this.self()).createResources(resources);
        if (CollectionUtils.isEmpty(menus)) {
            return menus;
        }
        Long[] roleResourceItemIds = null;
        ResourceItemAssign[] resourceItemAssigns = null;
        if (roleId != null) {
            roleResourceItemIds = this.roleResourceItemCache.getValue(roleId.toString());
            resourceItemAssigns = this.resourceItemAssignCache.getValue("role_" + roleId);
        }
        if (ArrayUtils.isEmpty(roleResourceItemIds) && ArrayUtils.isEmpty(resourceItemAssigns)) {
            return menus;
        }
        this.updateMenuCheck(menus, roleResourceItemIds, resourceItemAssigns);
        return menus;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<Resource> queryHtmlResources(IRequest requestContext, Function function) {
        Resource resource = new Resource();
        resource.setType("HTML");
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("function", function);
        params.put("resource", resource);
        return this.functionMapper.selectExistsResourcesByFunction(params);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<MenuItem> createResources(List<Resource> resourceList) {
        MenuItem root = new MenuItem();
        ArrayList<MenuItem> children = new ArrayList<MenuItem>();
        root.setChildren(children);
        if (resourceList != null) {
            ResourceItemCount itemCount = new ResourceItemCount();
            for (Resource resource : resourceList) {
                MenuItem resourceMenu = this.createResourceItems(resource, itemCount);
                if (resourceMenu == null) continue;
                children.add(resourceMenu);
            }
        }
        return root.getChildren();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<ResourceItemAssign> updateResourceItemAssign(IRequest requestContext, List<ResourceItemAssign> resourceItemAssignList, Long roleId, Long functionId) {
        this.roleResourceItemMapper.deleteByRoleIdAndFunctionId(roleId, functionId);
        this.resourceItemAssignMapper.deleteByRoleIdAndFunctionId(roleId, functionId);
        if (CollectionUtils.isNotEmpty(resourceItemAssignList)) {
            for (ResourceItemAssign resourceItemAssign : resourceItemAssignList) {
                if ("oldType".equalsIgnoreCase(resourceItemAssign.getAssignType())) {
                    RoleResourceItem roleResourceItem = new RoleResourceItem();
                    roleResourceItem.setRoleId(resourceItemAssign.getTypeId());
                    roleResourceItem.setResourceItemId(resourceItemAssign.getElementId());
                    this.roleResourceItemMapper.insertSelective(roleResourceItem);
                    continue;
                }
                if (!"newType".equalsIgnoreCase(resourceItemAssign.getAssignType())) continue;
                resourceItemAssign.setAssignType("role");
                resourceItemAssign.setEnable("N");
                resourceItemAssign.setFunctionId(functionId);
                this.resourceItemAssignMapper.insertSelective(resourceItemAssign);
            }
        }
        this.roleResourceItemCache.load(roleId.toString());
        this.resourceItemAssignCache.load("role_" + roleId);
        return resourceItemAssignList;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public boolean hasResourceItem(Long roleId, Long resourceItemId) {
        if (roleId == null || resourceItemId == null) {
            return false;
        }
        return this.roleResourceItemMapper.selectByRoleIdAndResourceItemId(roleId, resourceItemId) != null;
    }

    private void updateMenuCheck(List<MenuItem> menus, Long[] roleResourceItemIds, ResourceItemAssign[] resourceItemAssigns) {
        block0: for (MenuItem menuItem : menus) {
            if (CollectionUtils.isNotEmpty(menuItem.getChildren())) {
                this.updateMenuCheck(menuItem.getChildren(), roleResourceItemIds, resourceItemAssigns);
            }
            if ("oldData".equalsIgnoreCase(menuItem.getFunctionCode())) {
                if (!ArrayUtils.isNotEmpty((Object[])roleResourceItemIds)) continue;
                for (Serializable serializable : roleResourceItemIds) {
                    if (!menuItem.getId().equals(serializable)) continue;
                    menuItem.setIschecked(Boolean.TRUE);
                    continue block0;
                }
                continue;
            }
            if (!"newData".equalsIgnoreCase(menuItem.getFunctionCode()) || !ArrayUtils.isNotEmpty((Object[])resourceItemAssigns)) continue;
            for (Serializable serializable : resourceItemAssigns) {
                if (!menuItem.getId().equals(((ResourceItemAssign)serializable).getElementId())) continue;
                menuItem.setIschecked(Boolean.FALSE);
                continue block0;
            }
        }
    }

    private MenuItem createResourceItems(Resource resource, ResourceItemCount itemCount) {
        Object[] resourceItemList = this.resourceItemCache.getValue(resource.getResourceId().toString());
        MenuItem resourceMenu = null;
        if (ArrayUtils.isEmpty((Object[])resourceItemList)) {
            return resourceMenu;
        }
        resourceMenu = new MenuItem();
        resourceMenu.setText(resource.getName() + "(" + resource.getUrl() + ")");
        resourceMenu.setId(itemCount.getResourceId());
        itemCount.setResourceId(itemCount.getResourceId() - 10L);
        resourceMenu.setIcon("fa fa-file");
        ArrayList<MenuItem> resourceMenuChildren = new ArrayList<MenuItem>();
        resourceMenu.setChildren(resourceMenuChildren);
        HashMap<String, List<ResourceItem>> itemMap = new HashMap<String, List<ResourceItem>>(16);
        block10: for (Object resourceItem : resourceItemList) {
            String itemType;
            switch (itemType = ((ResourceItem)resourceItem).getItemType()) {
                case "variable": {
                    this.setResourceItems("variable", itemMap, (ResourceItem)resourceItem);
                    continue block10;
                }
                case "buttons": 
                case "form": 
                case "grid": {
                    this.setResourceItems("notVariable", itemMap, (ResourceItem)resourceItem);
                    continue block10;
                }
            }
        }
        if (itemMap.size() != 0) {
            List variableItemList = (List)itemMap.get("variable");
            List otherItemList = (List)itemMap.get("notVariable");
            if (CollectionUtils.isNotEmpty((Collection)variableItemList)) {
                this.resourceMenu(variableItemList, resourceMenuChildren, itemCount);
            }
            if (CollectionUtils.isNotEmpty((Collection)otherItemList)) {
                this.resourceMenu(otherItemList, resourceMenuChildren, itemCount);
            }
        }
        if (CollectionUtils.isEmpty(resourceMenu.getChildren())) {
            return null;
        }
        return resourceMenu;
    }

    private void setResourceItems(String type, Map<String, List<ResourceItem>> itemMap, ResourceItem resourceItem) {
        List<ResourceItem> sets = itemMap.get(type);
        if (sets == null) {
            sets = new ArrayList<ResourceItem>();
            itemMap.put(type, sets);
        }
        sets.add(resourceItem);
    }

    private void resourceMenu(List<ResourceItem> resourceItemList, List<MenuItem> resourceMenuChildren, ResourceItemCount itemCount) {
        String itemType = resourceItemList.get(0).getItemType();
        if ("variable".equalsIgnoreCase(itemType)) {
            MenuItem variateMenu = new MenuItem();
            variateMenu.setText("\u670d\u52a1\u7aef\u53d8\u91cf");
            variateMenu.setId(itemCount.getVariateId());
            variateMenu.setIschecked(Boolean.FALSE);
            variateMenu.setIcon("fa fa-info-circle");
            itemCount.setVariateId(itemCount.getVariateId() - 10L);
            resourceMenuChildren.add(variateMenu);
            ArrayList<MenuItem> variateMenuChildren = new ArrayList<MenuItem>();
            variateMenu.setChildren(variateMenuChildren);
            for (ResourceItem resourceItem : resourceItemList) {
                MenuItem variate = new MenuItem();
                variate.setText(resourceItem.getItemName());
                variate.setId(resourceItem.getResourceItemId());
                variate.setIcon("fa fa-pencil-square-o");
                variate.setFunctionCode("oldData");
                variateMenuChildren.add(variate);
            }
        } else {
            for (ResourceItem resourceItem : resourceItemList) {
                MenuItem menu = this.createResourceItemElements(resourceItem, itemCount);
                if (menu == null) continue;
                resourceMenuChildren.add(menu);
            }
        }
    }

    private MenuItem createResourceItemElements(ResourceItem resourceItem, ResourceItemCount itemCount) {
        MenuItem resourceItemMenu = null;
        Object[] elementList = this.resourceItemElementCache.getValue(resourceItem.getResourceItemId().toString());
        if (ArrayUtils.isEmpty((Object[])elementList)) {
            return resourceItemMenu;
        }
        resourceItemMenu = new MenuItem();
        resourceItemMenu.setText(this.translateItemType(resourceItem.getItemType()) + "  [" + resourceItem.getItemName() + "]");
        ArrayList<MenuItem> resourceItemChildren = new ArrayList<MenuItem>();
        resourceItemMenu.setChildren(resourceItemChildren);
        if ("buttons".equalsIgnoreCase(resourceItem.getItemType())) {
            resourceItemMenu.setIcon("fa  fa-hand-o-down");
            resourceItemMenu.setId(itemCount.getBtnGroupId());
            itemCount.setBtnGroupId(itemCount.getBtnGroupId() - 10L);
            for (Object button : elementList) {
                resourceItemChildren.add(this.createResourceItemElement((ResourceItemElement)button));
            }
        } else if ("form".equalsIgnoreCase(resourceItem.getItemType())) {
            resourceItemMenu.setIcon("fa fa-wpforms");
            resourceItemMenu.setId(itemCount.getFormId());
            itemCount.setFormId(itemCount.getFormId() - 10L);
            HashMap<String, List<ResourceItemElement>> itemMap = new HashMap<String, List<ResourceItemElement>>(16);
            block19: for (Object formElement : elementList) {
                String itemType;
                switch (itemType = ((ResourceItemElement)formElement).getType()) {
                    case "form-buttons": {
                        this.setResourceItemElements("form-buttons", itemMap, (ResourceItemElement)formElement);
                        continue block19;
                    }
                    case "form-field": {
                        this.setResourceItemElements("form-field", itemMap, (ResourceItemElement)formElement);
                        continue block19;
                    }
                }
            }
            if (itemMap.size() != 0) {
                List btnList = (List)itemMap.get("form-buttons");
                List fieldList = (List)itemMap.get("form-field");
                if (CollectionUtils.isNotEmpty((Collection)btnList)) {
                    this.setMenuItem(resourceItemChildren, btnList, itemCount, "form-buttons");
                }
                if (CollectionUtils.isNotEmpty((Collection)fieldList)) {
                    this.setMenuItem(resourceItemChildren, fieldList, itemCount, "form-field");
                }
            }
        } else if ("grid".equalsIgnoreCase(resourceItem.getItemType())) {
            resourceItemMenu.setIcon("fa fa-table");
            resourceItemMenu.setId(itemCount.getGridId());
            itemCount.setGridId(itemCount.getGridId() - 10L);
            HashMap<String, List<ResourceItemElement>> itemMap = new HashMap<String, List<ResourceItemElement>>(16);
            block20: for (Object gridElement : elementList) {
                String itemType;
                switch (itemType = ((ResourceItemElement)gridElement).getType()) {
                    case "grid-buttons": {
                        this.setResourceItemElements("grid-buttons", itemMap, (ResourceItemElement)gridElement);
                        continue block20;
                    }
                    case "column-buttons": {
                        this.setResourceItemElements("column-buttons", itemMap, (ResourceItemElement)gridElement);
                        continue block20;
                    }
                    case "column": {
                        this.setResourceItemElements("column", itemMap, (ResourceItemElement)gridElement);
                        continue block20;
                    }
                }
            }
            if (itemMap.size() != 0) {
                List toolbarList = (List)itemMap.get("grid-buttons");
                List colBtnList = (List)itemMap.get("column-buttons");
                List colList = (List)itemMap.get("column");
                if (CollectionUtils.isNotEmpty((Collection)toolbarList)) {
                    this.setMenuItem(resourceItemChildren, toolbarList, itemCount, "grid-buttons");
                }
                if (CollectionUtils.isNotEmpty((Collection)colBtnList)) {
                    this.setMenuItem(resourceItemChildren, colBtnList, itemCount, "column-buttons");
                }
                if (CollectionUtils.isNotEmpty((Collection)colList)) {
                    this.setMenuItem(resourceItemChildren, colList, itemCount, "column");
                }
            }
        }
        return resourceItemMenu;
    }

    private void setResourceItemElements(String type, Map<String, List<ResourceItemElement>> itemMap, ResourceItemElement resourceItemElement) {
        List<ResourceItemElement> sets = itemMap.get(type);
        if (sets == null) {
            sets = new ArrayList<ResourceItemElement>();
            itemMap.put(type, sets);
        }
        sets.add(resourceItemElement);
    }

    private void setMenuItem(List<MenuItem> resourceItemChildren, List<ResourceItemElement> resourceItemElementList, ResourceItemCount itemCount, String type) {
        MenuItem menuItem = new MenuItem();
        this.setMenuItemProperty(menuItem, itemCount, type);
        resourceItemChildren.add(menuItem);
        ArrayList<MenuItem> menuItemChildren = new ArrayList<MenuItem>();
        menuItem.setChildren(menuItemChildren);
        for (ResourceItemElement element : resourceItemElementList) {
            menuItemChildren.add(this.createResourceItemElement(element));
        }
    }

    private void setMenuItemProperty(MenuItem menuItem, ResourceItemCount itemCount, String type) {
        switch (type) {
            case "form-buttons": {
                menuItem.setId(itemCount.getBtnId());
                itemCount.setBtnId(itemCount.getBtnId() - 10L);
                menuItem.setText(this.translateElementType("form-buttons"));
                menuItem.setIcon("fa fa-hand-o-down");
                break;
            }
            case "form-field": {
                menuItem.setId(itemCount.getFieldId());
                itemCount.setFieldId(itemCount.getFieldId() - 10L);
                menuItem.setText(this.translateElementType("form-field"));
                menuItem.setIcon("fa fa-file-text");
                break;
            }
            case "grid-buttons": {
                menuItem.setId(itemCount.getToolbarId());
                itemCount.setToolbarId(itemCount.getToolbarId() - 10L);
                menuItem.setText(this.translateElementType("grid-buttons"));
                menuItem.setIcon("fa fa-bars");
                break;
            }
            case "column-buttons": {
                menuItem.setId(itemCount.getColumnButtonId());
                itemCount.setColumnButtonId(itemCount.getColumnButtonId() - 10L);
                menuItem.setText(this.translateElementType("column-buttons"));
                menuItem.setIcon("fa fa-hand-o-down");
                break;
            }
            case "column": {
                menuItem.setId(itemCount.getColumnId());
                itemCount.setColumnId(itemCount.getColumnId() - 10L);
                menuItem.setText(this.translateElementType("column"));
                menuItem.setIcon("fa fa-columns");
                break;
            }
        }
    }

    private MenuItem createResourceItemElement(ResourceItemElement resourceItemElement) {
        MenuItem menuItem = new MenuItem();
        menuItem.setText(resourceItemElement.getName());
        menuItem.setId(resourceItemElement.getElementId());
        menuItem.setIschecked(Boolean.TRUE);
        menuItem.setIcon("fa fa-pencil-square-o");
        menuItem.setFunctionCode("newData");
        return menuItem;
    }

    private String translateItemType(String type) {
        switch (type) {
            case "form": {
                type = "\u8868\u5355";
                break;
            }
            case "grid": {
                type = "\u8868\u683c";
                break;
            }
            case "buttons": {
                type = "\u6309\u94ae\u7ec4";
                break;
            }
        }
        return type;
    }

    private String translateElementType(String type) {
        switch (type) {
            case "grid-buttons": {
                type = "\u5de5\u5177\u680f\u6309\u94ae";
                break;
            }
            case "column-buttons": {
                type = "\u8868\u683c\u5217\u6309\u94ae";
                break;
            }
            case "column": {
                type = "\u8868\u683c\u5217";
                break;
            }
            case "form-buttons": {
                type = "\u6309\u94ae";
                break;
            }
            case "form-field": {
                type = "\u5b57\u6bb5";
                break;
            }
        }
        return type;
    }
}

