/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.function.service.impl;

import com.github.pagehelper.PageHelper;
import com.hand.hap.cache.impl.HashStringRedisCache;
import com.hand.hap.cache.impl.HashStringRedisCacheGroup;
import com.hand.hap.core.ILanguageProvider;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.annotation.StdWho;
import com.hand.hap.core.impl.RequestHelper;
import com.hand.hap.function.dto.Function;
import com.hand.hap.function.dto.FunctionResource;
import com.hand.hap.function.dto.MenuItem;
import com.hand.hap.function.dto.Resource;
import com.hand.hap.function.mapper.FunctionMapper;
import com.hand.hap.function.mapper.FunctionResourceMapper;
import com.hand.hap.function.mapper.RoleFunctionMapper;
import com.hand.hap.function.service.IFunctionService;
import com.hand.hap.function.service.IResourceService;
import com.hand.hap.function.service.IRoleFunctionService;
import com.hand.hap.message.IMessagePublisher;
import com.hand.hap.mybatis.common.Criteria;
import com.hand.hap.system.dto.Language;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FunctionServiceImpl
extends BaseServiceImpl<Function>
implements IFunctionService {
    @Autowired
    private FunctionMapper functionMapper;
    @Autowired
    private FunctionResourceMapper functionResourceMapper;
    @Autowired
    private RoleFunctionMapper roleFunctionMapper;
    @Autowired
    private IResourceService resourceService;
    @Autowired
    private IRoleFunctionService roleFunctionService;
    @Autowired
    @Qualifier(value="functionCache")
    private HashStringRedisCacheGroup<Function> functionCache;
    @Autowired
    private ILanguageProvider languageProvider;
    @Autowired
    private IMessagePublisher messagePublisher;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Function insertSelective(IRequest request, @StdWho Function function) {
        if (function == null) {
            return null;
        }
        super.insertSelective(request, function);
        this.reloadFunctionCache(function);
        return function;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Function updateByPrimaryKey(IRequest request, Function function) {
        if (function == null) {
            return null;
        }
        Criteria criteria = new Criteria(function);
        criteria.update("functionCode", "moduleCode", "functionName", "functionIcon", "functionSequence", "functionDescription", "parentFunctionId", "resourceId");
        criteria.updateExtensionAttribute();
        super.updateByPrimaryKeyOptions(request, function, criteria);
        this.reloadFunctionCache(function);
        return function;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public Function selectByPrimaryKey(IRequest request, Function function) {
        if (function == null || function.getFunctionId() == null) {
            return null;
        }
        return (Function)this.functionMapper.selectByPrimaryKey(function.getFunctionId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Function> batchUpdate(IRequest request, List<Function> functions) {
        if (CollectionUtils.isEmpty(functions)) {
            return functions;
        }
        for (Function function : functions) {
            if (function.getFunctionId() == null) {
                ((IFunctionService)this.self()).insertSelective(request, function);
                continue;
            }
            ((IFunctionService)this.self()).updateByPrimaryKey(request, function);
        }
        return functions;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int batchDelete(IRequest request, List<Function> functions) {
        int result = 0;
        if (CollectionUtils.isEmpty(functions)) {
            return result;
        }
        for (Function function : functions) {
            this.deleteByPrimaryKey(request, function);
            ++result;
        }
        return result;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<Function> selectFunction(IRequest request, Function function, int page, int pageSize) {
        Criteria criteria = new Criteria(function);
        criteria.unSelect("parentFunctionName");
        return super.selectOptions(request, function, criteria, page, pageSize);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<Resource> selectExitResourcesByFunction(IRequest request, Function function, Resource resource, int page, int pageSize) {
        if (function == null || function.getFunctionId() == null) {
            return null;
        }
        if (pageSize != 0) {
            PageHelper.startPage(page, pageSize);
        }
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("function", function);
        params.put("resource", resource);
        return this.functionMapper.selectExistsResourcesByFunction(params);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<Resource> selectNotExitResourcesByFunction(IRequest request, Function function, Resource resource, int page, int pageSize) {
        if (function == null || function.getFunctionId() == null) {
            return null;
        }
        PageHelper.startPage(page, pageSize);
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("function", function);
        params.put("resource", resource);
        return this.functionMapper.selectNotExistsResourcesByFunction(params);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Function updateFunctionResources(IRequest request, Function function, List<Resource> resources) {
        if (function != null && CollectionUtils.isNotEmpty(resources)) {
            for (Resource resource : resources) {
                if ("add".equals(resource.get__status())) {
                    FunctionResource functionResource = new FunctionResource();
                    functionResource.setResourceId(resource.getResourceId());
                    functionResource.setFunctionId(function.getFunctionId());
                    functionResource.setObjectVersionNumber(1L);
                    functionResource.setCreatedBy(request.getUserId());
                    functionResource.setCreationDate(new Date());
                    functionResource.setLastUpdateDate(new Date());
                    functionResource.setLastUpdatedBy(request.getUserId());
                    this.functionResourceMapper.insertSelective(functionResource);
                    continue;
                }
                if (!"delete".equals(resource.get__status())) continue;
                this.functionResourceMapper.deleteFunctionResource(function.getFunctionId(), resource.getResourceId());
            }
            this.notifyCache(null);
        }
        return function;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<MenuItem> selectAllMenus(IRequest request) {
        List<Function> functions = this.functionCache.getGroupAll(request.getLocale());
        MenuItem root = this.castFunctionsToMenuItem(functions);
        return root.getChildren();
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<MenuItem> selectRoleFunctions(IRequest request) {
        Long[] roleIds;
        List<Function> functions = this.functionCache.getGroupAll(request.getLocale());
        HashSet<Object> allRoleFunctionIds = new HashSet<Object>();
        for (Long l : roleIds = request.getAllRoleId()) {
            Object[] roleFunctionIds = this.roleFunctionService.getRoleFunctionById(l);
            if (!ArrayUtils.isNotEmpty((Object[])roleFunctionIds)) continue;
            allRoleFunctionIds.addAll(Arrays.asList(roleFunctionIds));
        }
        HashMap<Long, Function> functionMap = new HashMap<Long, Function>(16);
        if (CollectionUtils.isNotEmpty(functions)) {
            for (Function f : functions) {
                functionMap.put(f.getFunctionId(), f);
            }
        }
        HashMap<Long, MenuItem> menuMap = new HashMap<Long, MenuItem>(16);
        if (CollectionUtils.isNotEmpty(allRoleFunctionIds)) {
            for (Long l : allRoleFunctionIds) {
                this.createMenuRecursive(menuMap, functionMap, l);
            }
        }
        ArrayList<MenuItem> itemList = new ArrayList<MenuItem>();
        menuMap.forEach((k, v) -> {
            if (v.getParent() == null) {
                itemList.add((MenuItem)v);
            }
            if (v.getChildren() != null) {
                Collections.sort(v.getChildren());
            }
        });
        Collections.sort(itemList);
        return itemList;
    }

    private MenuItem castFunctionsToMenuItem(List<Function> functions) {
        MenuItem root = new MenuItem();
        ArrayList<MenuItem> children = new ArrayList<MenuItem>();
        root.setChildren(children);
        HashMap<Long, Function> idToFuncMap = new HashMap<Long, Function>(16);
        for (Function f : functions) {
            idToFuncMap.put(f.getFunctionId(), f);
        }
        HashMap<Long, MenuItem> map = new HashMap<Long, MenuItem>(16);
        Iterator<Function> iterator = functions.iterator();
        while (iterator.hasNext()) {
            Function function = iterator.next();
            if (idToFuncMap.get(function.getParentFunctionId()) != null) continue;
            MenuItem rootChild = this.createMenuItem(function);
            map.put(function.getFunctionId(), rootChild);
            children.add(rootChild);
            iterator.remove();
        }
        this.processFunctions(map, functions);
        map.forEach((k, v) -> {
            if (v.getChildren() != null) {
                Collections.sort(v.getChildren());
            }
        });
        Collections.sort(children);
        return root;
    }

    private void processFunctions(Map<Long, MenuItem> map, List<Function> functions) {
        Iterator<Function> iterator = functions.iterator();
        int functionSize = functions.size();
        while (iterator.hasNext()) {
            Function function = iterator.next();
            MenuItem parent = map.get(function.getParentFunctionId());
            if (parent == null) continue;
            MenuItem item = this.createMenuItem(function);
            map.put(function.getFunctionId(), item);
            List<MenuItem> children = parent.getChildren();
            if (children == null) {
                children = new ArrayList<MenuItem>();
                parent.setChildren(children);
            }
            children.add(item);
            iterator.remove();
        }
        if (functions.size() == functionSize) {
            this.detectCircle(functions);
        }
        if (!functions.isEmpty()) {
            this.processFunctions(map, functions);
        }
    }

    private void detectCircle(List<Function> functions) {
        HashMap<Long, Function> tmpFuncMap = new HashMap<Long, Function>(16);
        for (Function f : functions) {
            tmpFuncMap.put(f.getFunctionId(), f);
        }
        ArrayList<Function> tmpList = new ArrayList<Function>();
        for (Function f : functions) {
            tmpList.clear();
            Function f0 = f;
            tmpList.add(f0);
            while (f0.getParentFunctionId() != null) {
                int idx = tmpList.indexOf(f0 = (Function)tmpFuncMap.get(f0.getParentFunctionId()));
                if (idx != -1) {
                    tmpList.add(f0);
                    String msg = tmpList.stream().skip(idx).map(a -> a.getFunctionName() + "(" + a.getFunctionId() + ")").reduce((a, b) -> a + "-->" + b).get();
                    throw new RuntimeException(msg);
                }
                tmpList.add(f0);
            }
        }
    }

    private MenuItem createMenuRecursive(Map<Long, MenuItem> menuMap, Map<Long, Function> functionMap, Long functionId) {
        MenuItem menuItem = menuMap.get(functionId);
        if (menuItem == null) {
            MenuItem parentMenuItem;
            Function function = functionMap.get(functionId);
            if (function == null) {
                return null;
            }
            menuItem = this.createMenuItem(function);
            menuMap.put(functionId, menuItem);
            Long parentId = function.getParentFunctionId();
            if (parentId != null && (parentMenuItem = this.createMenuRecursive(menuMap, functionMap, parentId)) != null) {
                List<MenuItem> children = parentMenuItem.getChildren();
                if (children == null) {
                    children = new ArrayList<MenuItem>();
                    parentMenuItem.setChildren(children);
                }
                menuItem.setParent(parentMenuItem);
                children.add(menuItem);
            }
        }
        return menuItem;
    }

    private MenuItem createMenuItem(Function function) {
        MenuItem menu = new MenuItem();
        menu.setText(function.getFunctionName());
        menu.setIcon(function.getFunctionIcon());
        menu.setFunctionCode(function.getFunctionCode());
        menu.setUrl(function.getResourceUrl());
        menu.setId(function.getFunctionId());
        menu.setScore(function.getFunctionSequence());
        return menu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadFunctionCache(Function function) {
        IRequest old = RequestHelper.getCurrentRequest();
        try {
            IRequest iRequest = RequestHelper.newEmptyRequest();
            RequestHelper.setCurrentRequest(iRequest);
            for (Language language : this.languageProvider.getSupportedLanguages()) {
                iRequest.setLocale(language.getLangCode());
                Function f = this.functionMapper.selectForReloadCache(function);
                if (f == null) continue;
                ((HashStringRedisCache)this.functionCache.getGroup(language.getLangCode())).setValue(function.getFunctionId().toString(), f);
            }
        }
        finally {
            RequestHelper.setCurrentRequest(old);
        }
    }

    private void deleteFunctionCache(Long functionId) {
        for (Language language : this.languageProvider.getSupportedLanguages()) {
            ((HashStringRedisCache)this.functionCache.getGroup(language.getLangCode())).remove(functionId.toString());
        }
    }

    private int deleteByPrimaryKey(IRequest request, Function function) {
        if (function == null || function.getFunctionId() == null) {
            return 0;
        }
        List<Function> children = this.functionMapper.selectFunctionIdByParentId(function.getFunctionId());
        children.forEach(t -> this.deleteByPrimaryKey(request, (Function)t));
        int updateCount = this.functionMapper.deleteByPrimaryKey(function);
        this.checkOvn(updateCount, function);
        this.functionResourceMapper.deleteByFunctionId(function.getFunctionId());
        this.roleFunctionMapper.deleteByFunctionId(function.getFunctionId());
        this.deleteFunctionCache(function.getFunctionId());
        return updateCount;
    }

    private void notifyCache(Long roleId) {
        this.messagePublisher.publish("cache.role.resource", roleId);
    }
}

