/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.function.controllers;

import com.hand.hap.core.exception.BaseException;
import com.hand.hap.function.dto.ResourceCustomization;
import com.hand.hap.function.service.IResourceCustomizationService;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/resourceCustomization", "/api/sys/resourceCustomization"})
public class ResourceCustomizationController
extends BaseController {
    @Autowired
    private IResourceCustomizationService resourceCustomizationService;

    @RequestMapping(value={"/query"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseData query(HttpServletRequest request, Long resourceId) {
        return new ResponseData(this.resourceCustomizationService.selectResourceCustomizationsByResourceId(resourceId));
    }

    @PostMapping(value={"/submit"})
    public ResponseData submit(HttpServletRequest request, @RequestBody List<ResourceCustomization> resourceCustomizations, BindingResult result) throws BaseException {
        this.getValidator().validate(resourceCustomizations, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        return new ResponseData(this.resourceCustomizationService.batchUpdate(this.createRequestContext(request), resourceCustomizations));
    }

    @PostMapping(value={"/remove"})
    public ResponseData remove(HttpServletRequest request, @RequestBody List<ResourceCustomization> resourceCustomizations) throws BaseException {
        this.resourceCustomizationService.batchDelete(resourceCustomizations);
        return new ResponseData();
    }
}

