/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.function.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.function.dto.Function;
import com.hand.hap.function.dto.Resource;
import com.hand.hap.function.service.IFunctionService;
import com.hand.hap.mybatis.common.Criteria;
import com.hand.hap.mybatis.common.query.Comparison;
import com.hand.hap.mybatis.common.query.WhereField;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/function", "/api/sys/function"})
public class FunctionController
extends BaseController {
    @Autowired
    private IFunctionService functionService;

    @RequestMapping(value={"/fetchResource"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseData fetchResource(HttpServletRequest request, Long functionId, Integer isExit, Resource resource, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize) {
        IRequest requestContext = this.createRequestContext(request);
        Function function = new Function();
        function.setFunctionId(functionId);
        return new ResponseData(this.functionService.selectExitResourcesByFunction(requestContext, function, resource, page, pagesize));
    }

    @RequestMapping(value={"/fetchNotResource"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseData fetchNotResource(HttpServletRequest request, Long functionId, Integer isExit, Resource resource, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize) {
        IRequest requestContext = this.createRequestContext(request);
        Function function = new Function();
        if (StringUtils.isEmpty((String)resource.getUrl())) {
            resource.setUrl(null);
        }
        if (StringUtils.isEmpty((String)resource.getName())) {
            resource.setName(null);
        }
        if (StringUtils.isEmpty((String)resource.getType())) {
            resource.setType(null);
        }
        function.setFunctionId(functionId);
        return new ResponseData(this.functionService.selectNotExitResourcesByFunction(requestContext, function, resource, page, pagesize));
    }

    @RequestMapping(value={"/menus"}, method={RequestMethod.GET, RequestMethod.POST})
    public Object queryMenuTree(HttpServletRequest request) {
        return this.functionService.selectRoleFunctions(this.createRequestContext(request));
    }

    @RequestMapping(value={"/query"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseData query(Function function, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        Criteria criteria = new Criteria(function);
        criteria.where(new WhereField("functionCode", Comparison.LIKE), "functionName", "parentFunctionName", "parentFunctionId", new WhereField("moduleCode", Comparison.LIKE), "resourceId");
        return new ResponseData(this.functionService.selectOptions(requestContext, function, criteria, page, pagesize));
    }

    @PostMapping(value={"/remove"})
    public ResponseData remove(@RequestBody List<Function> functions, BindingResult result, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        this.functionService.batchDelete(requestContext, functions);
        return new ResponseData();
    }

    @PostMapping(value={"/submit"})
    public ResponseData submit(@RequestBody List<Function> functions, BindingResult result, HttpServletRequest request) {
        this.getValidator().validate(functions, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.functionService.batchUpdate(requestContext, functions));
    }

    @PostMapping(value={"/updateFunctionResource"})
    public ResponseData updateFunctionResource(HttpServletRequest request, @RequestBody Function function) {
        IRequest requestContext = this.createRequestContext(request);
        ResponseData data = new ResponseData();
        this.functionService.updateFunctionResources(requestContext, function, function.getResources());
        data.setSuccess(true);
        return data;
    }
}

