/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.web.view.xpath;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.hand.hap.core.web.view.XMap;
import com.hand.hap.core.web.view.xpath.Predicate;
import java.util.Iterator;

public class EqualPredicate
implements Predicate {
    private static final String EQUALS = "=";
    private static final Splitter EQUALS_SPLITTER = Splitter.on((String)"=").trimResults().omitEmptyStrings();
    private static final Splitter SPACE_SPLITTER = Splitter.on((String)" ").trimResults().omitEmptyStrings();
    private String attributeName;
    private String attributeValue;

    public EqualPredicate(String value) {
        Iterable attributes = SPACE_SPLITTER.split((CharSequence)value);
        Iterator iterator = attributes.iterator();
        while (iterator.hasNext()) {
            String att;
            Iterator<String> iter;
            this.addPredicate(iter.next(), (iter = EqualPredicate.splitByEquals(att = (String)iterator.next())).hasNext() ? iter.next() : "");
        }
    }

    private static Iterator<String> splitByEquals(String value) {
        Iterator<String> iter = EQUALS_SPLITTER.split((CharSequence)value).iterator();
        Preconditions.checkArgument((boolean)iter.hasNext(), (Object)("unable to parse attribute " + value));
        return iter;
    }

    @Override
    public boolean validate(XMap node) {
        String v = node.getString(this.attributeName);
        return v == null ? false : v.equals(this.attributeValue);
    }

    private void addPredicate(String name, String value) {
        Preconditions.checkArgument((!name.contains(EQUALS) ? 1 : 0) != 0);
        this.attributeName = name;
        this.attributeValue = EqualPredicate.buildValue(value);
    }

    private static String buildValue(String value) {
        return ((String)Preconditions.checkNotNull((Object)value)).replaceAll("'", "").replaceAll("\"", "");
    }
}

