/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.web.view.ui;

import com.hand.hap.core.web.view.ScreenBuilder;
import com.hand.hap.core.web.view.UITag;
import com.hand.hap.core.web.view.ViewContext;
import com.hand.hap.core.web.view.XMap;
import com.hand.hap.core.web.view.ui.Animation;
import com.hand.hap.core.web.view.ui.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@UITag
public class TabStrip
extends Component {
    private static final String PROPERTITY_ANIMATION = "animation";
    private static final String PROPERTITY_NAVIGATABLE = "navigatable";
    private static final String PROPERTITY_SCROLLABLE = "scrollable";
    private static final String PROPERTITY_DISTANCE = " distance";
    private static final String PROPERTITY_TAB_POSITION = "tabPosition";
    private static final String PROPERTITY_VALUE = "value";
    private static final String PROPERTITY_COLLAPSIBLE = "collapsible";
    private static final String PROPERTITY_TABS = "tabs";
    private static final String PROPERTITY_TAB = "tab";
    private static final String PROPERTIY_TITLE = "title";
    private static final String PROPERTITY_TAB_CONTENT = "tabContent";
    private static final String PROPERTITY_CONTENT_URLS = "contentUrls";
    private static final String PROPERTITY_DATA_CONTENT_FIELD = "dataContentField";
    private static final String PROPERTITY_DATA_CONTENT_URL_FIELD = "dataContentUrlField";
    private static final String PROPERTITY_DATA_IMAGE_URL_FIELD = "dataImageUrlField";
    private static final String PROPERTITY_DATA_SPRITE_CSS_CLASS = "dataSpriteCssClass";
    private static final String PROPERTITY_DATA_TEXT_FIELD = "dataTextField";
    private static final String PROPERTITY_DATA_URL_FIELD = "dataUrlField";
    private static final String PROPERTITY_DATA_CONTENT_IFRAME = "dataContentIframe";
    private static final String PROPERTITY_DATA_IFRAME_ID_FIELD = "dataIframeIdField";
    private static final String PROPERTITY_DATA_CLOSE_ICON_FIELD = "dataCloseIconField";
    private static final String PROPERTITY_CLOSE_ICON = "closeIcon";
    private static final String PROPERTITY_CONTEXT_MENU = "contextMenu";
    private static final String PROPERTITY_ACTIVATE = "activate";
    private static final String PROPERTITY_CONTENT_LOAD = "contentLoad";
    private static final String PROPERTITY_ERROR = "error";
    private static final String PROPERTITY_SELECT = "select";
    private static final String PROPERTITY_CHANGE = "change";
    private static final String PROPERTITY_DATABINDING = "dataBinding";
    private static final String PROPERTITY_DATABOUND = "dataBound";
    private static final String PROPERTITY_SHOW = "show";
    private static final String PROPERTITY_DATASOURCE = "dataSource";

    public static TabStrip createInstance() {
        XMap view = new XMap("h", "http://www.hand-china.com/hap", "tabStrip");
        TabStrip tabStrip = new TabStrip();
        tabStrip.initPrototype(view);
        return tabStrip;
    }

    public Object getAnimation() {
        XMap animation = this.getPrototype().getChild(PROPERTITY_ANIMATION);
        if (animation != null) {
            return Animation.parseAnimation(animation);
        }
        if (this.getPrototype().getBoolean(PROPERTITY_ANIMATION) != null) {
            return this.getPrototype().getBoolean(PROPERTITY_ANIMATION);
        }
        return null;
    }

    public void setAnimation(Animation animation) {
        this.getPrototype().addChild(animation.toXMap());
    }

    public String getTab() {
        List<XMap> maps;
        XMap tabs = this.getPrototype().getChild(PROPERTITY_TABS);
        StringBuilder sb = new StringBuilder();
        if (tabs != null && (maps = tabs.getChildren()) != null) {
            for (XMap tab : maps) {
                sb.append("<li>");
                sb.append(tab.getString(PROPERTIY_TITLE));
                sb.append("</li>");
            }
        }
        return sb.toString();
    }

    public void setTab(List<String> datas) {
        XMap tabs = this.getPrototype().getChild(PROPERTITY_TABS);
        if (tabs == null) {
            tabs = this.getPrototype().createChild(PROPERTITY_TABS);
        }
        ArrayList<XMap> tab = new ArrayList<XMap>();
        for (String value : datas) {
            XMap x = new XMap("h", "http://www.hand-china.com/hap", PROPERTITY_TAB);
            x.put(PROPERTIY_TITLE, value);
            tab.add(x);
        }
        tabs.addChild(tab);
    }

    public String getTabContent(ViewContext context) throws Exception {
        List<XMap> maps;
        StringBuffer sb = new StringBuffer();
        XMap tabs = this.getPrototype().getChild(PROPERTITY_TABS);
        if (tabs != null && (maps = tabs.getChildren()) != null) {
            for (XMap tab : maps) {
                sb.append("<div>");
                List<XMap> children = tab.getChildren();
                if (children != null) {
                    for (XMap child : children) {
                        sb.append(ScreenBuilder.build(child, context));
                    }
                }
                sb.append("</div>");
            }
        }
        return sb.toString();
    }

    public void setTabContent(Map<Object, List<XMap>> elements) {
        XMap tabs = this.getPrototype().getChild(PROPERTITY_TABS);
        if (tabs != null) {
            List<XMap> tabList = tabs.getChildren();
            for (XMap xMap : tabList) {
                for (Map.Entry<Object, List<XMap>> entry : elements.entrySet()) {
                    if (entry.getKey() != xMap.get(PROPERTIY_TITLE)) continue;
                    for (XMap map : entry.getValue()) {
                        xMap.addChild(map);
                    }
                }
            }
        }
    }

    public Boolean getContextMenu() {
        return this.getPrototype().getBoolean(PROPERTITY_CONTEXT_MENU);
    }

    public void setContextMenu(Boolean contextMenu) {
        this.setPropertity(PROPERTITY_CONTEXT_MENU, contextMenu);
    }

    public Boolean getCloseIcon() {
        return this.getPrototype().getBoolean(PROPERTITY_CLOSE_ICON);
    }

    public void setCloseIcon(Boolean closeIcon) {
        this.setPropertity(PROPERTITY_CLOSE_ICON, closeIcon);
    }

    public String getDataCloseIconField() {
        return this.getPrototype().getString(PROPERTITY_DATA_CLOSE_ICON_FIELD);
    }

    public void setDataCloseIconField(String dataCloseIconField) {
        this.setPropertity(PROPERTITY_DATA_CLOSE_ICON_FIELD, dataCloseIconField);
    }

    public String getDataContentIframe() {
        return this.getPrototype().getString(PROPERTITY_DATA_CONTENT_IFRAME);
    }

    public void setDataContentIframe(String dataContentIframe) {
        this.setPropertity(PROPERTITY_DATA_CONTENT_IFRAME, dataContentIframe);
    }

    public String getDataIframeIdField() {
        return this.getPrototype().getString(PROPERTITY_DATA_IFRAME_ID_FIELD);
    }

    public void setdataIframeIdField(String dataIframeIdField) {
        this.setPropertity(PROPERTITY_DATA_IFRAME_ID_FIELD, dataIframeIdField);
    }

    public Boolean getCollapsible() {
        return this.getPrototype().getBoolean(PROPERTITY_COLLAPSIBLE);
    }

    public void setCollapsible(Boolean collapsible) {
        this.setPropertity(PROPERTITY_COLLAPSIBLE, collapsible);
    }

    public String[] getContentUrls() {
        String urls = this.getPrototype().getString(PROPERTITY_CONTENT_URLS);
        if (urls != null) {
            String[] contentUrls = urls.split(",");
            return contentUrls;
        }
        return null;
    }

    public void setContentUrls(String contentUrls) {
        this.setPropertity(PROPERTITY_CONTENT_URLS, contentUrls);
    }

    public String getDataContentField() {
        return this.getPrototype().getString(PROPERTITY_DATA_CONTENT_FIELD);
    }

    public void setDataContentField(String dataContentField) {
        this.setPropertity(PROPERTITY_DATA_CONTENT_FIELD, dataContentField);
    }

    public String getDataContentUrlField() {
        return this.getPrototype().getString(PROPERTITY_DATA_CONTENT_URL_FIELD);
    }

    public void setDataContentUrlField(String dataContentUrlField) {
        this.setPropertity(PROPERTITY_DATA_CONTENT_URL_FIELD, dataContentUrlField);
    }

    public String getDataImageUrlField() {
        return this.getPrototype().getString(PROPERTITY_DATA_IMAGE_URL_FIELD);
    }

    public void setDataImageUrlField(String dataImageUrlField) {
        this.setPropertity(PROPERTITY_DATA_IMAGE_URL_FIELD, dataImageUrlField);
    }

    public String getDataSpriteCssClass() {
        return this.getPrototype().getString(PROPERTITY_DATA_SPRITE_CSS_CLASS);
    }

    public void setDataSpriteCssClass(String dataSpriteCssClass) {
        this.setPropertity(PROPERTITY_DATA_SPRITE_CSS_CLASS, dataSpriteCssClass);
    }

    public String getDataTextField() {
        return this.getPrototype().getString(PROPERTITY_DATA_TEXT_FIELD);
    }

    public void setDataTextField(String dataTextField) {
        this.setPropertity(PROPERTITY_DATA_TEXT_FIELD, dataTextField);
    }

    public String getDataUrlField() {
        return this.getPrototype().getString(PROPERTITY_DATA_URL_FIELD);
    }

    public void setDataUrlField(String dataUrlField) {
        this.setPropertity(PROPERTITY_DATA_URL_FIELD, dataUrlField);
    }

    public Boolean getNavigatable() {
        return this.getPrototype().getBoolean(PROPERTITY_NAVIGATABLE);
    }

    public void setNavigatable(Boolean navigatable) {
        this.setPropertity(PROPERTITY_NAVIGATABLE, navigatable);
    }

    public Object getScrollable() {
        Boolean scrollable = this.getPrototype().getBoolean(PROPERTITY_SCROLLABLE);
        XMap distance = this.getPrototype().getChild(PROPERTITY_SCROLLABLE);
        if (distance != null) {
            return distance;
        }
        return scrollable;
    }

    public void setScrollable(Boolean scrollable) {
        this.setPropertity(PROPERTITY_SCROLLABLE, scrollable);
    }

    public void setScrollable(Integer distance) {
        XMap x = new XMap("h", "http://www.hand-china.com/hap", PROPERTITY_SCROLLABLE);
        x.put(PROPERTITY_DISTANCE, distance);
        this.getPrototype().addChild(x);
    }

    public String getTabPosition() {
        return this.getPrototype().getString(PROPERTITY_TAB_POSITION);
    }

    public void setTabPosition(String tabPosition) {
        this.setPropertity(PROPERTITY_TAB_POSITION, tabPosition);
    }

    public String getValue() {
        return this.getPrototype().getString(PROPERTITY_VALUE);
    }

    public void setValue(String value) {
        this.setPropertity(PROPERTITY_VALUE, value);
    }

    @Override
    protected void initPrototype(XMap view) {
        super.initPrototype(view);
        this.addEvents(PROPERTITY_DATASOURCE, PROPERTITY_ACTIVATE, PROPERTITY_CONTENT_LOAD, PROPERTITY_SELECT, PROPERTITY_ERROR, PROPERTITY_SHOW, PROPERTITY_CHANGE, PROPERTITY_DATABINDING, PROPERTITY_DATABOUND);
    }

    @Override
    public void init(XMap view, ViewContext context) throws Exception {
        super.init(view, context);
        context.put(PROPERTITY_TAB, this.getTab());
        context.put(PROPERTITY_TAB_CONTENT, this.getTabContent(context));
        context.addJsonConfig(PROPERTITY_ANIMATION, this.getAnimation());
        context.addJsonConfig(PROPERTITY_COLLAPSIBLE, this.getCollapsible());
        context.addJsonConfig(PROPERTITY_CONTENT_URLS, this.getContentUrls());
        context.addJsonConfig(PROPERTITY_DATA_CONTENT_FIELD, this.getDataContentField());
        context.addJsonConfig(PROPERTITY_DATA_CONTENT_URL_FIELD, this.getDataContentUrlField());
        context.addJsonConfig(PROPERTITY_DATA_IMAGE_URL_FIELD, this.getDataImageUrlField());
        context.addJsonConfig(PROPERTITY_DATA_SPRITE_CSS_CLASS, this.getDataSpriteCssClass());
        context.addJsonConfig(PROPERTITY_DATA_TEXT_FIELD, this.getDataTextField());
        context.addJsonConfig(PROPERTITY_DATA_URL_FIELD, this.getDataUrlField());
        context.addJsonConfig(PROPERTITY_NAVIGATABLE, this.getNavigatable());
        context.addJsonConfig(PROPERTITY_SCROLLABLE, this.getScrollable());
        context.addJsonConfig(PROPERTITY_TAB_POSITION, this.getTabPosition());
        context.addJsonConfig(PROPERTITY_VALUE, this.getValue());
    }
}

