/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.web.view.ui;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.hand.hap.core.web.view.XMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GridPageable {
    private Integer pageSize;
    private Boolean previousNext;
    private Boolean numeric;
    private Integer buttonCount;
    private Boolean input;
    private Object pageSizes;
    private Boolean refresh;
    private Boolean info;
    private Map<Object, Object> messages;
    private static final String PROPERTITY_PAGEABLE = "pageable";
    private static final String PROPERTITY_PAGE_SIZE = "pageSize";
    private static final String PROPERTITY_PREVIOUS_NEXT = "previousNext";
    private static final String PROPERTITY_NUMERIC = "numeric";
    private static final String PROPERTITY_BUTTON_COUNT = "buttonCount";
    private static final String PROPERTITY_INPUT = "input";
    private static final String PROPERTITY_PAGE_SIZES = "pageSizes";
    private static final String PROPERTITY_REFRESH = "refresh";
    private static final String PROPERTITY_INFO = "info";
    private static final String PROPERTITY_MESSAGES = "messages";

    public static GridPageable parsePageable(XMap map) {
        GridPageable pageable = new GridPageable();
        if (map != null) {
            pageable.setPageSize(map.getInteger(PROPERTITY_PAGE_SIZE));
            pageable.setPreviousNext(map.getBoolean(PROPERTITY_PREVIOUS_NEXT));
            pageable.setNumeric(map.getBoolean(PROPERTITY_NUMERIC));
            pageable.setButtonCount(map.getInteger(PROPERTITY_BUTTON_COUNT));
            pageable.setInput(map.getBoolean(PROPERTITY_INPUT));
            String pageSizes = map.getString(PROPERTITY_PAGE_SIZES);
            if (pageSizes != null) {
                if (pageSizes.equals("true") || pageSizes.equals("false")) {
                    pageable.setPageSizes(map.getBoolean(PROPERTITY_PAGE_SIZES));
                } else {
                    pageable.setPageSizes(map.getString(PROPERTITY_PAGE_SIZES));
                }
            }
            pageable.setRefresh(map.getBoolean(PROPERTITY_REFRESH));
            pageable.setInfo(map.getBoolean(PROPERTITY_INFO));
            pageable.setMessages(map.getChild(PROPERTITY_MESSAGES));
            return pageable;
        }
        return null;
    }

    public XMap toXMap() {
        XMap map = new XMap("h", "http://www.hand-china.com/hap", PROPERTITY_PAGEABLE);
        if (this.getPageSizes() != null) {
            if (this.getPageSizes() instanceof Boolean) {
                map.put(PROPERTITY_PAGE_SIZES, this.getPageSizes());
            } else {
                map.put(PROPERTITY_PAGE_SIZES, String.join((CharSequence)",", this.getPageSizes().toString()));
            }
        }
        map.put(PROPERTITY_PREVIOUS_NEXT, this.getPreviousNext());
        map.put(PROPERTITY_NUMERIC, this.getNumeric());
        map.put(PROPERTITY_BUTTON_COUNT, this.getButtonCount());
        map.put(PROPERTITY_INPUT, this.getInput());
        map.put(PROPERTITY_PAGE_SIZE, this.getPageSize());
        map.put(PROPERTITY_REFRESH, this.getRefresh());
        map.put(PROPERTITY_INFO, this.getInfo());
        XMap messages = new XMap("h", "http://www.hand-china.com/hap", PROPERTITY_MESSAGES);
        if (this.getMessages() != null) {
            for (Object key : this.getMessages().keySet()) {
                messages.put(key, this.getMessages().get(key));
            }
        }
        map.addChild(messages);
        return map;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Boolean getPreviousNext() {
        return this.previousNext;
    }

    public void setPreviousNext(Boolean previousNext) {
        this.previousNext = previousNext;
    }

    public Boolean getNumeric() {
        return this.numeric;
    }

    public void setNumeric(Boolean numeric) {
        this.numeric = numeric;
    }

    public Integer getButtonCount() {
        return this.buttonCount;
    }

    public void setButtonCount(Integer buttonCount) {
        this.buttonCount = buttonCount;
    }

    public Boolean getInput() {
        return this.input;
    }

    public void setInput(Boolean input) {
        this.input = input;
    }

    public Object getPageSizes() {
        return this.pageSizes;
    }

    public void setPageSizes(String pageSizes) {
        if (pageSizes != null) {
            String[] data = pageSizes.split(",");
            int length = data.length;
            Object[] datas = new Object[length];
            for (int i = 0; i < length; ++i) {
                try {
                    datas[i] = Integer.parseInt(data[i].trim());
                    continue;
                }
                catch (Exception e) {
                    datas[i] = data[i].trim();
                }
            }
            this.pageSizes = datas;
        }
    }

    public void setPageSizes(Boolean pageSizes) {
        this.pageSizes = pageSizes;
    }

    public Boolean getRefresh() {
        return this.refresh;
    }

    public void setRefresh(Boolean refresh) {
        this.refresh = refresh;
    }

    public Boolean getInfo() {
        return this.info;
    }

    public void setInfo(Boolean info) {
        this.info = info;
    }

    public Map<Object, Object> getMessages() {
        return this.messages;
    }

    public void setMessages(Map<Object, Object> messages) {
        this.messages = messages;
    }
}

