/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.web.view.ui;

import com.hand.hap.core.web.view.ReferenceType;
import com.hand.hap.core.web.view.UITag;
import com.hand.hap.core.web.view.ViewContext;
import com.hand.hap.core.web.view.XMap;
import com.hand.hap.core.web.view.ui.Component;
import com.hand.hap.core.web.view.ui.Model;
import com.hand.hap.core.web.view.ui.Schema;
import com.hand.hap.core.web.view.ui.Transport;
import com.hand.hap.core.web.view.ui.TransportMethod;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@UITag
public class DataSource
extends Component {
    private static final String PROPERTITY_DATA = "data";
    private static final String PROPERTITY_TRANSPORT = "transport";
    public static final String PROPERTITY_SCHEMA = "schema";
    private static final String PROPERTITY_AUTO_SYNC = "autoSync";
    private static final String PROPERTITY_BATCH = "batch";
    private static final String PROPERTITY_PAGE = "page";
    private static final String PROPERTITY_PAGE_SIZE = "pageSize";
    private static final String PROPERTITY_SERVER_AGGREGATES = "serverAggregates";
    private static final String PROPERTITY_SERVER_FILTERING = "serverFiltering";
    private static final String PROPERTITY_SERVER_GROUPING = "serverGrouping";
    private static final String PROPERTITY_SERVER_PAGING = "serverPaging";
    private static final String PROPERTITY_SERVER_SORTING = "serverSorting";
    private static final String PROPERTITY_TYPE = "type";
    private static final String PROPERTITY_READ = "read";
    private static final String PROPERTITY_CREATE = "create";
    private static final String PROPERTITY_UPDATE = "update";
    private static final String PROPERTITY_DESTROY = "destroy";
    private static final String PROPERTITY_PARAMETER_MAP = "parameterMap";
    private static final String PROPERTITY_CHANGE = "change";
    private static final String PROPERTITY_ERROR = "error";
    private static final String PROPERTITY_PUSH = "push";
    private static final String PROPERTITY_REQUEST_END = "requestEnd";
    private static final String PROPERTITY_REQUEST_START = "requestStart";
    private static final String PROPERTITY_SYNC = "sync";
    private static final String PROPERTITY_SORT = "sort";
    private static final String PROPERTITY_DIR = "dir";
    private static final String PROPERTITY_ITEM = "item";
    private static final String PROPERTITY_COMPARE = "compare";
    private static final String PROPERTITY_DATA_SOURCE = "dataSource";
    private static final String PROPERTITY_FIELD = "field";

    public static DataSource createInstance() {
        XMap view = new XMap("h", "http://www.hand-china.com/hap", PROPERTITY_DATA_SOURCE);
        DataSource dataSource = new DataSource();
        dataSource.initPrototype(view);
        return dataSource;
    }

    public String getData() {
        return this.getPrototype().getString(PROPERTITY_DATA);
    }

    public void setData(String data) {
        this.setPropertity(PROPERTITY_DATA, data);
    }

    public List<XMap> getDatas() {
        XMap data = this.getPrototype().getChild(PROPERTITY_DATA);
        if (data != null) {
            return data.getChildren();
        }
        return null;
    }

    public void setDatas(List<Map<String, Object>> datas) {
        XMap data = this.getPrototype().getChild(PROPERTITY_DATA);
        if (data == null) {
            data = this.getPrototype().createChild("h", "http://www.hand-china.com/hap", PROPERTITY_DATA);
        }
        ArrayList<XMap> list = new ArrayList<XMap>();
        if (datas != null) {
            for (Map<String, Object> map : datas) {
                XMap x = new XMap("h", "http://www.hand-china.com/hap", PROPERTITY_ITEM);
                if (map == null) continue;
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    x.put(entry.getKey(), entry.getValue());
                }
                list.add(x);
            }
        }
        data.addChild(list);
    }

    public Boolean getAutoSync() {
        return this.getPrototype().getBoolean(PROPERTITY_AUTO_SYNC);
    }

    public void setAutoSync(Boolean autoSync) {
        this.setPropertity(PROPERTITY_AUTO_SYNC, autoSync);
    }

    public Boolean getBatch() {
        return this.getPrototype().getBoolean(PROPERTITY_BATCH);
    }

    public void setBatch(Boolean batch) {
        this.setPropertity(PROPERTITY_BATCH, batch);
    }

    public Integer getPage() {
        return this.getPrototype().getInteger(PROPERTITY_PAGE);
    }

    public void setPage(Integer page) {
        this.setPropertity(PROPERTITY_PAGE, page);
    }

    public Integer getPageSize() {
        return this.getPrototype().getInteger(PROPERTITY_PAGE_SIZE);
    }

    public void setPageSize(Integer pageSize) {
        this.setPropertity(PROPERTITY_PAGE_SIZE, pageSize);
    }

    public Boolean getServerAggregates() {
        return this.getPrototype().getBoolean(PROPERTITY_SERVER_AGGREGATES);
    }

    public void setServerAggregates(Boolean serverAggregates) {
        this.setPropertity(PROPERTITY_SERVER_AGGREGATES, serverAggregates);
    }

    public Boolean getServerFiltering() {
        return this.getPrototype().getBoolean(PROPERTITY_SERVER_FILTERING);
    }

    public void setServerFiltering(Boolean serverFiltering) {
        this.setPropertity(PROPERTITY_SERVER_FILTERING, serverFiltering);
    }

    public Boolean getServerGrouping() {
        return this.getPrototype().getBoolean(PROPERTITY_SERVER_GROUPING);
    }

    public void setServerGrouping(Boolean serverGrouping) {
        this.setPropertity(PROPERTITY_SERVER_GROUPING, serverGrouping);
    }

    public Boolean getServerPaging() {
        return this.getPrototype().getBoolean(PROPERTITY_SERVER_PAGING);
    }

    public void setServerPaging(Boolean serverPaging) {
        this.setPropertity(PROPERTITY_SERVER_PAGING, serverPaging);
    }

    public Boolean getServerSorting() {
        return this.getPrototype().getBoolean(PROPERTITY_SERVER_SORTING);
    }

    public void setServerSorting(Boolean serverSorting) {
        this.setPropertity(PROPERTITY_SERVER_SORTING, serverSorting);
    }

    public String getType() {
        return this.getPrototype().getString(PROPERTITY_TYPE);
    }

    public void setType(String type) {
        this.setPropertity(PROPERTITY_TYPE, type);
    }

    public Object getSort() {
        XMap sort = this.getPrototype().getChild(PROPERTITY_SORT);
        ArrayList<XMap> map = new ArrayList<XMap>();
        if (sort != null) {
            List<XMap> list = sort.getChildren();
            if (list != null) {
                for (XMap child : list) {
                    String compare = child.getString(PROPERTITY_COMPARE);
                    if (compare != null) {
                        child.put(PROPERTITY_COMPARE, new ReferenceType(compare));
                    }
                    map.add(child);
                }
                return map;
            }
            return sort;
        }
        return null;
    }

    public void addSort(String dir, String field, ReferenceType compare) {
        XMap sort = this.getPrototype().getChild(PROPERTITY_SORT);
        if (sort == null) {
            sort = this.getPrototype().createChild("h", "http://www.hand-china.com/hap", PROPERTITY_SORT);
        }
        sort.put(PROPERTITY_DIR, dir);
        sort.put(PROPERTITY_FIELD, field);
        sort.put(PROPERTITY_COMPARE, compare);
    }

    public void setSort(List<Map<String, Object>> sorts) {
        XMap sort = this.getPrototype().getChild(PROPERTITY_SORT);
        if (sort == null) {
            sort = this.getPrototype().createChild("h", "http://www.hand-china.com/hap", PROPERTITY_SORT);
        }
        ArrayList<XMap> list = new ArrayList<XMap>();
        for (Map<String, Object> map : sorts) {
            XMap x = new XMap("h", "http://www.hand-china.com/hap", PROPERTITY_ITEM);
            if (map == null) continue;
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                x.put(entry.getKey(), entry.getValue());
            }
            list.add(x);
        }
        sort.addChild(list);
    }

    public Object getSchema() {
        XMap map = this.getPrototype().getChild(PROPERTITY_SCHEMA);
        if (map != null) {
            return Schema.parseXMap(map);
        }
        return null;
    }

    public void setSchema(Schema schema) {
        this.getPrototype().addChild(schema.toXMap());
    }

    public Object getTransport() {
        Transport transport = new Transport();
        XMap map = this.getPrototype().getChild(PROPERTITY_TRANSPORT);
        if (map != null) {
            transport.setRead(TransportMethod.parse(map.getChild(PROPERTITY_READ)));
            transport.setCreate(TransportMethod.parse(map.getChild(PROPERTITY_CREATE)));
            transport.setUpdate(TransportMethod.parse(map.getChild(PROPERTITY_UPDATE)));
            transport.setDestroy(TransportMethod.parse(map.getChild(PROPERTITY_DESTROY)));
            if (map.getString(PROPERTITY_PARAMETER_MAP) != null) {
                transport.setParameterMap(new ReferenceType(map.getString(PROPERTITY_PARAMETER_MAP)));
            }
            if (map.getString(PROPERTITY_PUSH) != null) {
                transport.setPush(new ReferenceType(map.getString(PROPERTITY_PUSH)));
            }
            return transport;
        }
        return null;
    }

    public void setTransport(Transport transport) {
        XMap map = this.getPrototype().getChild(PROPERTITY_TRANSPORT);
        if (map == null) {
            map = this.getPrototype().createChild("h", "http://www.hand-china.com/hap", PROPERTITY_TRANSPORT);
        }
        map.addChild(transport.toXMap());
    }

    public void setModel(Model model) {
        XMap schema = this.getPrototype().getChild(PROPERTITY_SCHEMA);
        if (schema == null) {
            schema = this.getPrototype().createChild("h", "http://www.hand-china.com/hap", PROPERTITY_SCHEMA);
        }
        schema.addChild(model.toXMap());
    }

    @Override
    protected void initPrototype(XMap view) {
        super.initPrototype(view);
        this.addEvents(PROPERTITY_CHANGE, PROPERTITY_ERROR, PROPERTITY_PUSH, PROPERTITY_REQUEST_END, PROPERTITY_REQUEST_START, PROPERTITY_SYNC);
    }

    @Override
    public void init(XMap view, ViewContext context) throws Exception {
        super.init(view, context);
        context.addJsonConfig(PROPERTITY_DATA, this.getData());
        context.addJsonConfig(PROPERTITY_DATA, this.getDatas());
        context.addJsonConfig(PROPERTITY_TRANSPORT, this.getTransport());
        context.addJsonConfig(PROPERTITY_SCHEMA, this.getSchema());
        context.addJsonConfig(PROPERTITY_AUTO_SYNC, this.getAutoSync());
        context.addJsonConfig(PROPERTITY_BATCH, this.getBatch());
        context.addJsonConfig(PROPERTITY_PAGE, this.getPage());
        context.addJsonConfig(PROPERTITY_PAGE_SIZE, this.getPageSize());
        context.addJsonConfig(PROPERTITY_SERVER_AGGREGATES, this.getServerAggregates());
        context.addJsonConfig(PROPERTITY_SERVER_FILTERING, this.getServerFiltering());
        context.addJsonConfig(PROPERTITY_SERVER_GROUPING, this.getServerGrouping());
        context.addJsonConfig(PROPERTITY_SERVER_PAGING, this.getServerPaging());
        context.addJsonConfig(PROPERTITY_SERVER_SORTING, this.getServerSorting());
        context.addJsonConfig(PROPERTITY_TYPE, this.getType());
        context.addJsonConfig(PROPERTITY_SORT, this.getSort());
    }
}

