/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.util;

import com.hand.hap.attachment.ContentTypeFilter;
import com.hand.hap.attachment.FileInfo;
import com.hand.hap.attachment.Uploader;
import com.hand.hap.attachment.dto.AttachCategory;
import com.hand.hap.attachment.dto.Attachment;
import com.hand.hap.attachment.dto.SysFile;
import com.hand.hap.attachment.exception.StoragePathNotExsitException;
import com.hand.hap.attachment.impl.StandardController;
import java.io.File;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class UploadUtil {
    public static final String BASE_PATH = "${basePath}";

    protected UploadUtil() {
    }

    public static void initUploaderParams(Uploader uploader, AttachCategory category) throws StoragePathNotExsitException {
        uploader.setCategory(category);
        if (category.getAllowedFileSize() != null) {
            uploader.setSingleFileSize(category.getAllowedFileSize());
        }
        final String path = category.getCategoryPath();
        uploader.setController(new StandardController(){

            @Override
            public String getFileDir(HttpServletRequest request, String orginalName) {
                File f;
                String newPath = path;
                if (newPath.contains(UploadUtil.BASE_PATH)) {
                    newPath = newPath.replace(UploadUtil.BASE_PATH, request.getSession().getServletContext().getRealPath("/"));
                }
                if (!(f = new File(newPath)).exists()) {
                    f.mkdirs();
                }
                return f.getAbsolutePath() + File.separator;
            }

            @Override
            public String urlFix(HttpServletRequest request, File file) {
                return file.getAbsolutePath();
            }
        });
        if (StringUtils.isNotBlank((CharSequence)category.getAllowedFileType())) {
            final String[] allowedExts = category.getAllowedFileType().toLowerCase().split(";");
            uploader.setFilter(new ContentTypeFilter(){

                @Override
                public boolean isAccept(String orginalName, String contentType) {
                    for (String ext : allowedExts) {
                        if (!orginalName.toLowerCase().endsWith(ext)) continue;
                        return true;
                    }
                    return false;
                }
            });
        }
    }

    public static SysFile genSysFile(FileInfo f, Long createdBy, Long lastUpdateBy) {
        SysFile sysFile = new SysFile();
        sysFile.setFileName(f.getOriginalName());
        sysFile.setFileSize(f.getFile().length());
        sysFile.setUploadDate(new Date());
        sysFile.setCreatedBy(createdBy);
        sysFile.setLastUpdatedBy(lastUpdateBy);
        sysFile.setFilePath(f.getUrl());
        sysFile.setFileType(f.getContentType());
        return sysFile;
    }

    public static Attachment genAttachment(AttachCategory category, String sourceKey, Long creatBy, Long updateBy) {
        Attachment attach = new Attachment();
        attach.setCategoryId(category.getCategoryId());
        attach.setName(category.getSourceType());
        attach.setSourceType(category.getSourceType());
        attach.setStartActiveDate(new Date());
        attach.setEndActiveDate(new Date());
        attach.setSourceKey(sourceKey);
        attach.setCreatedBy(creatBy);
        attach.setLastUpdatedBy(updateBy);
        attach.setStatus("1");
        return attach;
    }

    public static void deleteFile(String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return;
        }
        File file = new File(path);
        if (file.exists()) {
            file.delete();
        }
    }
}

