/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.impl;

import com.hand.hap.cache.Cache;
import com.hand.hap.cache.CacheDelete;
import com.hand.hap.cache.CacheManager;
import com.hand.hap.cache.CacheSet;
import com.hand.hap.cache.impl.HashStringRedisCache;
import com.hand.hap.cache.impl.HashStringRedisCacheGroup;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.IRequestAware;
import com.hand.hap.core.annotation.StdWho;
import com.hand.hap.core.impl.RequestHelper;
import com.hand.hap.mybatis.entity.EntityField;
import com.hand.hap.system.dto.BaseDTO;
import com.hand.hap.system.dto.DTOClassInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;

public class ServiceExecutionAdvice
implements MethodInterceptor {
    private Logger logger = LoggerFactory.getLogger(ServiceExecutionAdvice.class);
    @Autowired
    private CacheManager cacheManager;

    void initMDC(IRequest request) {
        if (request != null) {
            request.getAttributeMap().forEach((key, v) -> {
                if (key.startsWith("MDC.")) {
                    String mdcProperty = key.substring("MDC.".length());
                    MDC.put((String)mdcProperty, (String)((String)v));
                }
            });
        }
    }

    public void before(Method method, Object[] args, Object target) throws Throwable {
        Class<?>[] types = method.getParameterTypes();
        int idx = -1;
        for (int i = 0; i < types.length; ++i) {
            if (!IRequest.class.isAssignableFrom(types[i])) continue;
            idx = i;
            break;
        }
        if (idx == -1) {
            return;
        }
        IRequest requestContext = (IRequest)args[idx];
        if (requestContext == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("{}'s IRequest argument is null.", (Object)method);
            }
            return;
        }
        RequestHelper.setCurrentRequest(requestContext);
        this.initMDC(requestContext);
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < types.length; ++i) {
            StdWho who = parameters[i].getAnnotation(StdWho.class);
            if (who != null && this.logger.isTraceEnabled()) {
                this.logger.trace("enable StdWho for argument {}, type: {}", (Object)i, (Object)types[i].getName());
            }
            if (args[i] instanceof IRequestAware) {
                ((IRequestAware)args[i]).setRequest(requestContext);
            }
            if (args[i] instanceof BaseDTO) {
                BaseDTO baseDTO = (BaseDTO)args[i];
                this.autoAssignStdProperty(this.logger, requestContext, baseDTO, who != null);
                continue;
            }
            if (!(args[i] instanceof Collection)) continue;
            for (Object o : (Collection)args[i]) {
                if (args[i] instanceof IRequestAware) {
                    ((IRequestAware)args[i]).setRequest(requestContext);
                }
                if (!(o instanceof BaseDTO)) continue;
                this.autoAssignStdProperty(this.logger, requestContext, (BaseDTO)o, who != null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object target = invocation.getThis();
        Method method = invocation.getMethod();
        Logger serviceLogger = LoggerFactory.getLogger(target.getClass());
        String methodStamp = target + "#" + method.getName();
        if (this.logger.isTraceEnabled()) {
            serviceLogger.trace("{}, parameters: {}", (Object)methodStamp, (Object)Arrays.toString(invocation.getArguments()));
        }
        long ts = System.currentTimeMillis();
        try {
            this.before(method, invocation.getArguments(), target);
            Object ret = invocation.proceed();
            if (this.logger.isTraceEnabled()) {
                serviceLogger.trace("{}, return value: {}", (Object)methodStamp, ret);
            }
            this.proceedAutoCacheOperation(invocation, ret);
            Object object = ret;
            return object;
        }
        finally {
            long timeUsed = System.currentTimeMillis() - ts;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("{}, execution time: {}ms.", (Object)methodStamp, (Object)timeUsed);
            }
        }
    }

    protected boolean checkChildrenType(Class<?> type) {
        if (BaseDTO.class.isAssignableFrom(type)) {
            return true;
        }
        return Collection.class.isAssignableFrom(type);
    }

    private void autoAssignStdProperty(Logger logger, IRequest request, BaseDTO dto, boolean stdWhoSupport) {
        if (stdWhoSupport) {
            for (EntityField f : DTOClassInfo.getIdFields(dto.getClass())) {
                try {
                    if (PropertyUtils.getProperty((Object)dto, (String)f.getName()) != null) continue;
                    dto.setCreatedBy(request.getUserId());
                    dto.setCreationDate(new Date());
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            dto.setLastUpdateDate(new Date());
            dto.setLastUpdatedBy(request.getUserId());
            dto.setLastUpdateLogin(request.getUserId());
        }
        for (EntityField field : DTOClassInfo.getChildrenFields(dto.getClass())) {
            if (!this.checkChildrenType(field.getJavaType())) {
                if (logger.isWarnEnabled()) {
                    logger.warn("property '{}' is annotated by @Children, incorrect usage.", (Object)field.getName());
                }
                return;
            }
            try {
                Object p = PropertyUtils.getProperty((Object)dto, (String)field.getName());
                if (p instanceof BaseDTO) {
                    this.autoAssignStdProperty(logger, request, (BaseDTO)p, stdWhoSupport);
                    continue;
                }
                if (!(p instanceof Collection)) continue;
                for (Object o : (Collection)p) {
                    if (!(o instanceof BaseDTO)) continue;
                    this.autoAssignStdProperty(logger, request, (BaseDTO)o, stdWhoSupport);
                }
            }
            catch (Exception e) {
                if (!logger.isErrorEnabled()) continue;
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void proceedAutoCacheOperation(MethodInvocation invocation, Object ret) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        CacheDelete cacheDelete;
        Object target = invocation.getThis();
        Method method = invocation.getMethod();
        method = target.getClass().getMethod(method.getName(), method.getParameterTypes());
        CacheSet cacheSet = (CacheSet)AnnotationUtils.findAnnotation((Method)method, CacheSet.class);
        if (cacheSet != null) {
            this.proceedCacheSet(method, cacheSet, ret);
        }
        if ((cacheDelete = (CacheDelete)AnnotationUtils.findAnnotation((Method)method, CacheDelete.class)) != null) {
            this.proceedCacheDelete(invocation, cacheDelete);
        }
    }

    private void proceedCacheSet(Method method, CacheSet cacheSet, Object ret) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        String valueField;
        String cacheName = cacheSet.cache();
        if (!StringUtils.hasText((String)cacheName)) {
            throw new IllegalArgumentException("cache: " + cacheName + " is not valid.");
        }
        Cache<Object> cache = this.cacheManager.getCache(cacheName);
        if (cache == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("cache: {} not found.", (Object)cacheName);
            }
            return;
        }
        String key = cache.getCacheKey(ret);
        if (cache instanceof HashStringRedisCache && (valueField = ((HashStringRedisCache)cache).getValueField()) != null) {
            ret = PropertyUtils.getProperty((Object)ret, (String)valueField);
        }
        cache.setValue(key, ret);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{} cache auto set. key={}", (Object)method.getName(), (Object)key);
        }
    }

    private void proceedCacheDelete(MethodInvocation invocation, CacheDelete cacheDelete) throws NoSuchMethodException {
        String cacheName = cacheDelete.cache();
        if (!StringUtils.hasText((String)cacheName)) {
            throw new IllegalArgumentException("cache: " + cacheName + " is not valid.");
        }
        Cache<Object> cache = this.cacheManager.getCache(cacheName);
        if (cache == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("cache: {} not found.", (Object)cacheName);
            }
            return;
        }
        Object dto = invocation.getArguments()[0];
        String key = cache.getCacheKey(dto);
        if (cache instanceof HashStringRedisCacheGroup) {
            HashStringRedisCacheGroup hashStringRedisCacheGroup = (HashStringRedisCacheGroup)cache;
            String group = hashStringRedisCacheGroup.getGroupValue(dto);
            hashStringRedisCacheGroup.remove(group, key);
        } else {
            cache.remove(key);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{} cache auto remove. key={}", (Object)invocation.getMethod().getName(), (Object)key);
        }
    }
}

