/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.util.CollectionUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.util.Pool;

public class CustomJedisConnectionFactory
extends JedisConnectionFactory {
    private int poolDb = 0;

    public CustomJedisConnectionFactory() {
    }

    public CustomJedisConnectionFactory(RedisSentinelConfiguration sentinelConfig) {
        super(sentinelConfig);
    }

    public CustomJedisConnectionFactory(RedisClusterConfiguration clusterConfig) {
        super(clusterConfig);
    }

    protected Pool<Jedis> createRedisPool() {
        return new JedisPool((GenericObjectPoolConfig)this.getPoolConfig(), this.getShardInfo().getHost(), this.getShardInfo().getPort(), this.getShardInfo().getSoTimeout(), this.getShardInfo().getPassword(), this.poolDb);
    }

    protected Pool<Jedis> createRedisSentinelPool(RedisSentinelConfiguration config) {
        return new JedisSentinelPool(config.getMaster().getName(), this.convertToJedisSentinelSet(config.getSentinels()), (GenericObjectPoolConfig)(this.getPoolConfig() != null ? this.getPoolConfig() : new JedisPoolConfig()), this.getShardInfo().getSoTimeout(), this.getShardInfo().getPassword(), this.poolDb);
    }

    public void setPoolDb(int poolDb) {
        this.poolDb = poolDb;
    }

    private Set<String> convertToJedisSentinelSet(Collection<RedisNode> nodes) {
        if (CollectionUtils.isEmpty(nodes)) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> convertedNodes = new LinkedHashSet<String>(nodes.size());
        for (RedisNode node : nodes) {
            if (node == null) continue;
            convertedNodes.add(node.asString());
        }
        return convertedNodes;
    }
}

