/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.cache.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.hand.hap.account.dto.User;
import com.hand.hap.cache.impl.HashStringRedisCache;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class UserCache<T>
extends HashStringRedisCache<User> {
    private final Logger logger = LoggerFactory.getLogger(UserCache.class);
    private final Long EXPIRE_TIME = 21600L;
    @Value(value="${sys.userCache.clearCacheOnStartUp:false}")
    private boolean CLEAR_USER_CACHE;

    public UserCache() {
        this.setLoadOnStartUp(false);
        this.setType(User.class);
    }

    @Override
    public void init() {
        super.init();
        if (this.CLEAR_USER_CACHE) {
            this.clearAll();
        }
    }

    @Override
    public User getValue(String key) {
        return (User)this.getRedisTemplate().execute(connection -> {
            byte[] keyBytes = this.strSerializer.serialize((Object)(this.getFullKey(null) + ":" + key.toLowerCase()));
            byte[] valueBytes = connection.get(keyBytes);
            try {
                if (null != valueBytes) {
                    return (User)this.getObjectMapper().readValue(valueBytes, User.class);
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            return null;
        });
    }

    @Override
    public void setValue(String key, User user) {
        try {
            byte[] keyBytes = this.strSerializer.serialize((Object)(this.getFullKey(null) + ":" + key.toLowerCase()));
            String value = this.getObjectMapper().writeValueAsString((Object)user);
            this.getRedisTemplate().execute(connection -> {
                connection.setEx(keyBytes, this.EXPIRE_TIME.longValue(), this.strSerializer.serialize((Object)value));
                return null;
            });
        }
        catch (JsonProcessingException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void remove(String key) {
        this.getRedisTemplate().execute(connection -> {
            byte[] keyBytes = this.strSerializer.serialize((Object)(this.getFullKey(null) + ":" + key.toLowerCase()));
            connection.del((byte[][])new byte[][]{keyBytes});
            return null;
        });
    }

    public void clearAll() {
        this.getRedisTemplate().execute(connection -> {
            byte[] keyBytes = this.strSerializer.serialize((Object)(this.getFullKey(null) + ":*"));
            Set keys = connection.keys(keyBytes);
            Iterator iterable = keys.iterator();
            while (iterable.hasNext()) {
                connection.del((byte[][])new byte[][]{(byte[])iterable.next()});
            }
            return null;
        });
    }
}

