/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.cache.impl;

import com.hand.hap.cache.impl.HashStringRedisCacheGroup;
import com.hand.hap.core.ILanguageProvider;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.impl.RequestHelper;
import com.hand.hap.core.impl.ServiceRequest;
import com.hand.hap.system.dto.Code;
import com.hand.hap.system.dto.CodeValue;
import com.hand.hap.system.dto.Language;
import com.hand.hap.system.mapper.CodeMapper;
import com.hand.hap.system.mapper.CodeValueMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SysCodeCache
extends HashStringRedisCacheGroup<Code> {
    private Logger logger = LoggerFactory.getLogger(SysCodeCache.class);
    private String codeQuerySqlId = CodeMapper.class.getName() + ".select";
    private String codeValueQuerySqlId = CodeValueMapper.class.getName() + ".select";
    @Autowired
    private ILanguageProvider languageProvider;

    public SysCodeCache() {
        this.setLoadOnStartUp(true);
        this.setType(Code.class);
        this.setGroupField(new String[]{"lang"});
        this.setKeyField(new String[]{"code"});
    }

    @Override
    public Code getValue(String key) {
        String[] keys = this.retrieveGroupAndKey(key);
        return (Code)super.getValue(keys[0], keys[1]);
    }

    private String[] retrieveGroupAndKey(String key) {
        String group = "zh_CN";
        String str = ".";
        if (key != null && key.indexOf(str) != -1) {
            group = StringUtils.substringAfterLast((String)key, (String)str);
            key = StringUtils.substringBeforeLast((String)key, (String)str);
        }
        return new String[]{group, key};
    }

    @Override
    public void setValue(String key, Code code) {
        String[] keys = this.retrieveGroupAndKey(key);
        super.setValue(keys[0], keys[1], code);
    }

    @Override
    public void remove(String key) {
        for (Language language : this.languageProvider.getSupportedLanguages()) {
            super.remove(language.getLangCode(), key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(Long codeId) {
        IRequest oldRequest = RequestHelper.getCurrentRequest();
        try (SqlSession sqlSession = this.getSqlSessionFactory().openSession();){
            for (Language language : this.languageProvider.getSupportedLanguages()) {
                ServiceRequest request = new ServiceRequest();
                request.setLocale(language.getLangCode());
                RequestHelper.setCurrentRequest(request);
                Code para = new Code();
                para.setCodeId(codeId);
                Code code = (Code)sqlSession.selectOne(this.codeQuerySqlId, (Object)para);
                CodeValue p2 = new CodeValue();
                p2.setCodeId(codeId);
                p2.setSortname("orderSeq");
                List codeValues = sqlSession.selectList(this.codeValueQuerySqlId, (Object)p2);
                code.setCodeValues(codeValues);
                this.setValue(language.getLangCode(), code.getCode(), code);
            }
        }
        finally {
            RequestHelper.setCurrentRequest(oldRequest);
        }
    }

    @Override
    protected void initLoad() {
        block15: {
            HashMap<Long, Code> tempMap = new HashMap<Long, Code>(64);
            try (SqlSession sqlSession = this.getSqlSessionFactory().openSession();){
                for (Language language : this.languageProvider.getSupportedLanguages()) {
                    ServiceRequest request = new ServiceRequest();
                    request.setLocale(language.getLangCode());
                    RequestHelper.setCurrentRequest(request);
                    sqlSession.select(this.codeQuerySqlId, resultContext -> {
                        Code code = (Code)resultContext.getResultObject();
                        tempMap.put(code.getCodeId(), code);
                    });
                    CodeValue cV = new CodeValue();
                    cV.setSortname("orderSeq");
                    sqlSession.select(this.codeValueQuerySqlId, (Object)cV, resultContext -> {
                        CodeValue value = (CodeValue)resultContext.getResultObject();
                        Code code = (Code)tempMap.get(value.getCodeId());
                        if (code != null) {
                            List<CodeValue> codeValues = code.getCodeValues();
                            if (codeValues == null) {
                                codeValues = new ArrayList<CodeValue>();
                                code.setCodeValues(codeValues);
                            }
                            codeValues.add(value);
                        }
                    });
                    tempMap.forEach((k, v) -> this.setValue(language.getLangCode(), v.getCode(), v));
                    tempMap.clear();
                }
                RequestHelper.clearCurrentRequest();
            }
            catch (Throwable e) {
                if (!this.logger.isErrorEnabled()) break block15;
                this.logger.error("init syscode exception ", e);
            }
        }
    }
}

