/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.audit.service.impl;

import com.hand.hap.audit.mapper.AuditMapper;
import com.hand.hap.audit.service.IAuditLogService;
import com.hand.hap.audit.service.IAuditService;
import com.hand.hap.core.components.ApplicationContextHelper;
import com.hand.hap.core.web.view.IDGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AuditServiceImpl
implements IAuditService {
    private Logger logger = LoggerFactory.getLogger(AuditServiceImpl.class);
    @Value(value="${db.type}")
    private String dataSourceType;
    @Autowired
    private AuditMapper auditMapper;
    @Autowired(required=false)
    private IAuditLogService auditLogService;
    private final String MSG_AUDIT_ERROR = "Audit Failures";

    @Override
    @Transactional(propagation=Propagation.NESTED, rollbackFor={Exception.class})
    public void insertAudit(Map<String, Object> updateMap, Map<String, Object> insertMap) {
        try {
            this.updateAuditFlag(updateMap);
            List<Map<String, Object>> records = this.selectOperateRecord(insertMap);
            List cols = (List)insertMap.get("_COLS");
            if (!records.isEmpty()) {
                for (Map<String, Object> dto : records) {
                    for (String field : cols) {
                        Object obj;
                        Object object = obj = dto.get(field) == null ? dto.get(field.toUpperCase()) : dto.get(field);
                        if (this.dataSourceType.equalsIgnoreCase("mssql")) {
                            insertMap.put(field, obj == null ? "" : obj);
                            continue;
                        }
                        insertMap.put(field, obj);
                    }
                    insertMap.put("_AUDIT_ID", IDGenerator.getInstance().generate());
                    this.auditMapper.auditInsert(insertMap);
                }
            }
        }
        catch (Exception e) {
            if (this.auditLogService == null) {
                this.auditLogService = (IAuditLogService)ApplicationContextHelper.getApplicationContext().getBean(IAuditLogService.class);
            }
            if (this.auditLogService != null) {
                HashMap<String, Object> auditLog = new HashMap<String, Object>(5);
                auditLog.put("operator", insertMap.get("_LAST_UPDATED_BY"));
                auditLog.put("message", e.getMessage());
                auditLog.put("sql", insertMap.get("sql"));
                this.auditLogService.auditlog(auditLog);
            }
            this.logger.error("Audit Failures");
            this.logger.error(e.getMessage());
            throw e;
        }
    }

    @Override
    public void updateAuditFlag(Map<String, Object> map) {
        if (this.dataSourceType.equalsIgnoreCase("mysql") || this.dataSourceType.equalsIgnoreCase("oracle")) {
            this.auditMapper.auditUpdateTag(map);
        } else if (this.dataSourceType.equalsIgnoreCase("mssql")) {
            this.auditMapper.auditUpdateTagSqlserver(map);
        }
    }

    @Override
    public List<Map<String, Object>> selectOperateRecord(Map<String, Object> map) {
        return this.auditMapper.selectOperateRecord(map);
    }
}

