/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.api.gateway.controllers;

import com.hand.hap.api.gateway.dto.ApiServer;
import com.hand.hap.api.gateway.service.IApiInvokeService;
import com.hand.hap.api.gateway.service.IApiServerService;
import com.hand.hap.api.gateway.service.impl.ApiInvokeServiceManager;
import com.hand.hap.api.logs.dto.ApiResponseData;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ApiInvokeContoller {
    @Autowired
    ApiInvokeServiceManager srInvokeServiceManager;
    @Autowired
    private IApiServerService serverService;

    @RequestMapping(value={"/api/rest/{serverUrl}/{interfaceUrl}"}, method={RequestMethod.GET, RequestMethod.POST})
    public ApiResponseData sentRequest(HttpServletRequest request, @PathVariable String serverUrl, @PathVariable String interfaceUrl, @RequestBody(required=false) JSONObject inbound) throws Exception {
        ApiServer server = this.serverService.getByMappingUrl(serverUrl, interfaceUrl);
        ApiResponseData apiResponseData = new ApiResponseData();
        List<IApiInvokeService> invokeServices = this.srInvokeServiceManager.getInvokeServices();
        for (IApiInvokeService service : invokeServices) {
            if (!service.matchServerType(server.getServiceType())) continue;
            Object result = service.invoke(server, inbound);
            apiResponseData.setRows(Arrays.asList(result));
            break;
        }
        return apiResponseData;
    }
}

