/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.activiti.manager;

import com.hand.hap.activiti.util.ActivitiUtils;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.impl.RequestHelper;
import com.hand.hap.hr.dto.Position;
import com.hand.hap.hr.mapper.PositionMapper;
import com.hand.hap.message.IMessageConsumer;
import com.hand.hap.message.TopicMonitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.identity.Group;
import org.activiti.engine.impl.persistence.entity.GroupEntity;
import org.activiti.engine.impl.persistence.entity.data.impl.MybatisGroupDataManager;
import org.activiti.spring.SpringProcessEngineConfiguration;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

@TopicMonitor(channel={"position.change"})
public class CustomGroupDataManager
extends MybatisGroupDataManager
implements IMessageConsumer<Position>,
InitializingBean {
    @Autowired
    private PositionMapper positionMapper;
    private Map<String, Map<String, GroupEntity>> multiLangGroupCache = new HashMap<String, Map<String, GroupEntity>>();
    @Autowired
    private SpringProcessEngineConfiguration pec;

    public CustomGroupDataManager() {
        super(null);
    }

    public List<Group> findGroupsByUser(String userId) {
        List<Position> positions = this.positionMapper.getPositionByEmployeeCode(userId);
        ArrayList<Group> gs = new ArrayList<Group>();
        for (Position position : positions) {
            gs.add((Group)ActivitiUtils.toActivitiGroup(position));
        }
        return gs;
    }

    public GroupEntity findById(String entityId) {
        GroupEntity groupEntity;
        IRequest request = RequestHelper.getCurrentRequest(true);
        Map<String, GroupEntity> groupCache = this.multiLangGroupCache.get(request.getLocale());
        if (groupCache == null) {
            groupCache = new HashMap<String, GroupEntity>();
            this.multiLangGroupCache.put(request.getLocale(), groupCache);
        }
        if ((groupEntity = groupCache.get(entityId)) == null) {
            Position position = this.positionMapper.getPositionByCode(entityId);
            groupEntity = ActivitiUtils.toActivitiGroup(position);
            groupCache.put(entityId, groupEntity);
        }
        return groupEntity;
    }

    @Override
    public void onMessage(Position message, String pattern) {
        this.multiLangGroupCache.forEach((k, v) -> {
            GroupEntity cfr_ignored_0 = (GroupEntity)v.remove(message.getPositionCode());
        });
    }

    public void afterPropertiesSet() throws Exception {
        this.processEngineConfiguration = this.pec;
    }
}

