/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.activiti.exception.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.hand.hap.mybatis.annotation.ExtensionAttribute;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.validator.constraints.NotEmpty;

@ExtensionAttribute(disable=true)
@Table(name="act_exception")
public class ActiviException {
    @Id
    @GeneratedValue(generator="IDENTITY")
    private Long id;
    @NotEmpty
    private String procId;
    @JsonIgnore
    private byte[] message;
    @Transient
    private String messStr;
    private Date duedate;
    @Transient
    private String procDefName;

    public ActiviException() {
    }

    public ActiviException(String procId, String messStr, Date duedate) {
        this.procId = procId;
        this.duedate = duedate;
        byte[] mesb = null;
        try {
            mesb = messStr.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        this.message = mesb;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setProcId(String procId) {
        this.procId = procId;
    }

    public String getProcId() {
        return this.procId;
    }

    public byte[] getMessage() {
        return this.message;
    }

    public void setMessage(byte[] message) {
        this.message = message;
    }

    public Date getDuedate() {
        return this.duedate;
    }

    public void setDuedate(Date duedate) {
        this.duedate = duedate;
    }

    public String getProcDefName() {
        return this.procDefName;
    }

    public void setProcDefName(String procDefName) {
        this.procDefName = procDefName;
    }

    public String getMessStr() {
        if (this.message != null) {
            try {
                this.messStr = new String(this.message, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return this.messStr;
    }

    public void setMessStr(String messStr) {
        this.messStr = messStr;
    }
}

