/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.activiti.custom;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.db.DbSqlSession;
import org.activiti.engine.impl.db.DbSqlSessionFactory;
import org.activiti.engine.impl.db.HasRevision;
import org.activiti.engine.impl.persistence.cache.EntityCache;
import org.activiti.engine.impl.persistence.entity.Entity;

public class CustomDbSqlSession
extends DbSqlSession {
    public CustomDbSqlSession(DbSqlSessionFactory dbSqlSessionFactory, EntityCache entityCache) {
        super(dbSqlSessionFactory, entityCache);
    }

    public CustomDbSqlSession(DbSqlSessionFactory dbSqlSessionFactory, EntityCache entityCache, Connection connection, String catalog, String schema) {
        super(dbSqlSessionFactory, entityCache, connection, catalog, schema);
    }

    protected void flushBulkInsert(Collection<Entity> entities, Class<? extends Entity> clazz) {
        String insertStatement = this.dbSqlSessionFactory.getInsertStatement(clazz);
        if ((insertStatement = this.dbSqlSessionFactory.mapStatement(insertStatement)) == null) {
            throw new ActivitiException("no insert statement for " + entities.iterator().next().getClass() + " in the ibatis mapping files");
        }
        Iterator<Entity> entityIterator = entities.iterator();
        Boolean hasRevision = null;
        while (entityIterator.hasNext()) {
            ArrayList<Entity> subList = new ArrayList<Entity>();
            for (int index = 0; entityIterator.hasNext() && index < this.dbSqlSessionFactory.getMaxNrOfStatementsInBulkInsert(); ++index) {
                Entity entity = entityIterator.next();
                subList.add(entity);
                if (hasRevision != null) continue;
                hasRevision = entity instanceof HasRevision;
            }
            for (Entity entity : subList) {
                this.sqlSession.insert(insertStatement, (Object)entity);
            }
        }
        if (hasRevision != null && hasRevision.booleanValue()) {
            entityIterator = entities.iterator();
            while (entityIterator.hasNext()) {
                this.incrementRevision(entityIterator.next());
            }
        }
    }
}

