/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.activiti.components;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hand.hap.account.dto.Role;
import com.hand.hap.account.mapper.RoleMapper;
import com.hand.hap.activiti.approval.dto.ApproveCandidateRule;
import com.hand.hap.activiti.approval.dto.ApproveStrategy;
import com.hand.hap.activiti.approval.dto.BusinessRuleHeader;
import com.hand.hap.activiti.approval.dto.BusinessRuleLine;
import com.hand.hap.activiti.approval.mapper.ApproveCandidateRuleMapper;
import com.hand.hap.activiti.approval.mapper.ApproveStrategyMapper;
import com.hand.hap.activiti.approval.mapper.BusinessRuleHeaderMapper;
import com.hand.hap.activiti.approval.mapper.BusinessRuleLineMapper;
import com.hand.hap.activiti.core.IActivitiConstants;
import com.hand.hap.activiti.custom.IActivitiBean;
import com.hand.hap.activiti.util.ActivitiUtils;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.impl.RequestHelper;
import com.hand.hap.hr.dto.Employee;
import com.hand.hap.hr.dto.Position;
import com.hand.hap.hr.mapper.EmployeeMapper;
import com.hand.hap.hr.mapper.PositionMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FormProperty;
import org.activiti.bpmn.model.FormValue;
import org.activiti.bpmn.model.UserTask;
import org.activiti.editor.constants.EditorJsonConstants;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.el.ExpressionManager;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApprovalRule
implements IActivitiBean,
IActivitiConstants,
EditorJsonConstants {
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String CODE = "code";
    private static final String YES = "Y";
    private static final String ENUM_VALUES = "enumValues";
    private static final String ASSIGNEE = "assignee";
    private static final String ASSIGNEE_CODE = "assigneeCode";
    private static final String ASSIGNEE_NAME = "assigneeName";
    private static final String FORM_PROPERTIES = "formProperties";
    private static final String APPROVE_STRATEGY = "approve_strategy";
    private static final String APPROVE_RULE = "approve_rule";
    private static final String DESCRIPTION = "description";
    private static final String RULES = "rules";
    private static final Logger logger = LoggerFactory.getLogger(ApprovalRule.class);
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private ApproveCandidateRuleMapper candidateRuleMapper;
    @Autowired
    private BusinessRuleHeaderMapper businessRuleHeaderMapper;
    @Autowired
    private BusinessRuleLineMapper businessRuleLineMapper;
    @Autowired
    private ApproveStrategyMapper strategyMapper;
    @Autowired
    private PositionMapper positionMapper;
    @Autowired
    private EmployeeMapper employeeMapper;
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private ProcessEngineConfigurationImpl processEngineConfiguration;

    public Set<String> getApprovalRule(DelegateExecution execution) {
        FlowElement element = execution.getCurrentFlowElement();
        if (!(element instanceof UserTask)) {
            logger.error("must be a UserTask can use this expression");
            throw new ActivitiException("must be a UserTask can use this expression");
        }
        UserTask task = (UserTask)element;
        return this.processCandidate(task, execution);
    }

    public Set<String> processCandidate(UserTask task, DelegateExecution execution) {
        ExpressionManager expressionManager = this.processEngineConfiguration.getExpressionManager();
        LinkedHashSet<String> candidates = new LinkedHashSet<String>();
        FormProperty property = ActivitiUtils.getFormPropertyById(task.getFormProperties(), "APPROVAL_CANDIDATE_RULE");
        List values = property.getFormValues();
        if (values == null) {
            logger.warn("APPROVAL_CANDIDATE has no formValue check formProperty");
            return candidates;
        }
        JsonNode ruleJson = null;
        for (FormValue value : values) {
            List emps;
            JsonNode codeObj;
            String strategyCode = value.getId();
            ApproveCandidateRule candidateRule = this.getCandidateRule(strategyCode);
            if (candidateRule == null) {
                logger.warn("code :" + strategyCode + " is disable or not exist");
                continue;
            }
            String jsonVule = value.getName();
            try {
                ruleJson = this.objectMapper.readTree(jsonVule);
            }
            catch (IOException e) {
                logger.warn(e.getMessage());
            }
            if (!this.hasPermission(ruleJson, execution)) continue;
            ArrayNode parameters = (ArrayNode)ruleJson.get("parameter");
            if ("APPOINTED_EMPLOYEE".equalsIgnoreCase(strategyCode)) {
                for (JsonNode para : parameters) {
                    codeObj = para.get("employeeCode");
                    if (codeObj == null) {
                        logger.warn("employee code is null");
                        continue;
                    }
                    String employeeCode = codeObj.textValue();
                    execution.setVariableLocal("employeeCode", (Object)employeeCode);
                    Object empCode = expressionManager.createExpression(candidateRule.getExpression()).getValue((VariableScope)execution);
                    candidates.add(empCode.toString());
                }
                continue;
            }
            if ("APPOINTED_POSITION".equalsIgnoreCase(strategyCode)) {
                for (JsonNode para : parameters) {
                    codeObj = para.get("positionCode");
                    if (codeObj == null) {
                        logger.warn("position code is null");
                        continue;
                    }
                    String positionCode = codeObj.textValue();
                    execution.setVariableLocal("positionCode", (Object)positionCode);
                    emps = (List)expressionManager.createExpression(candidateRule.getExpression()).getValue((VariableScope)execution);
                    candidates.addAll(emps);
                }
                continue;
            }
            if ("APPOINTED_ROLE".equalsIgnoreCase(strategyCode)) {
                for (JsonNode para : parameters) {
                    codeObj = para.get("roleCode");
                    if (codeObj == null) {
                        logger.warn("role code is null");
                        continue;
                    }
                    String roleCode = codeObj.textValue();
                    execution.setVariableLocal("roleCode", (Object)roleCode);
                    emps = (List)expressionManager.createExpression(candidateRule.getExpression()).getValue((VariableScope)execution);
                    candidates.addAll(emps);
                }
                continue;
            }
            try {
                Object user = expressionManager.createExpression(candidateRule.getExpression()).getValue((VariableScope)execution);
                if (user == null) continue;
                HashSet users = null;
                if (user instanceof String) {
                    users = org.springframework.util.StringUtils.commaDelimitedListToSet((String)user.toString());
                } else if (user instanceof Set) {
                    users = (Set)user;
                } else if (user instanceof List) {
                    users = new HashSet((List)user);
                } else {
                    logger.error("expression " + candidateRule.getExpression() + " result type must be String, List or Set .not support " + user.getClass().toString());
                }
                if (users == null) continue;
                candidates.addAll(users);
            }
            catch (ActivitiException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (candidates.size() == 0) {
            logger.warn("The current node has no approver");
            candidates.add("");
        }
        return candidates;
    }

    public ObjectNode processCustomProperties(ObjectNode content) {
        ArrayList<ObjectNode> userTask = new ArrayList<ObjectNode>();
        this.processUserTaskNode(content, userTask);
        for (ObjectNode child : userTask) {
            ObjectNode prop = (ObjectNode)child.get("properties");
            ObjectNode formProp = (ObjectNode)prop.get(FORM_PROPERTIES.toLowerCase());
            if (formProp == null || formProp.isNull()) continue;
            ArrayNode formPropVaule = (ArrayNode)formProp.get(FORM_PROPERTIES);
            block15: for (JsonNode value : formPropVaule) {
                String valueId;
                switch (valueId = value.get(ID).asText()) {
                    case "APPROVAL_STRATEGY": {
                        String code = value.get(NAME).asText();
                        ApproveStrategy record = new ApproveStrategy();
                        record.setCode(code);
                        record = this.strategyMapper.selectOne(record);
                        if (record == null) break;
                        prop.put(APPROVE_STRATEGY, record.getDescription());
                        break;
                    }
                    case "WFL_NUM": {
                        JsonNode numObj = value.get(NAME);
                        if (numObj == null || numObj.isNull()) break;
                        Double num = numObj.asDouble();
                        prop.put("WFL_NUM".toLowerCase(), num);
                        break;
                    }
                    case "APPROVAL_ACTION": {
                        ArrayNode enumValues = (ArrayNode)value.get(ENUM_VALUES);
                        for (JsonNode node : enumValues) {
                            String actionType = node.get(ID).asText();
                            if (!"ADD_SIGN_FLAG".equalsIgnoreCase(actionType) && !"DELEGATE_FLAG".equalsIgnoreCase(actionType)) continue;
                            prop.put(actionType.toLowerCase(), YES.equalsIgnoreCase(node.get(NAME).asText()));
                        }
                        continue block15;
                    }
                    case "APPROVAL_CANDIDATE_RULE": {
                        prop.set(APPROVE_RULE, (JsonNode)this.processCadidateRuleNode((ObjectNode)value));
                        break;
                    }
                    case "ACT_REVOKE_ENABLE_FLAG": {
                        JsonNode revokeFlag = value.get(NAME);
                        if (revokeFlag == null || revokeFlag.isNull()) break;
                        String flag = revokeFlag.asText();
                        prop.put("REVOKE_ENABLE_FLAG".toLowerCase(), YES.equalsIgnoreCase(flag));
                    }
                }
            }
        }
        return content;
    }

    private void processUserTaskNode(ObjectNode content, List<ObjectNode> userTask) {
        ArrayNode childShaps = (ArrayNode)content.get("childShapes");
        for (JsonNode key : childShaps) {
            ObjectNode child = (ObjectNode)key;
            String id = child.get("stencil").get(ID).asText();
            if ("userTask".equalsIgnoreCase(id)) {
                userTask.add(child);
                continue;
            }
            this.processUserTaskNode(child, userTask);
        }
    }

    private ObjectNode processCadidateRuleNode(ObjectNode value) {
        ArrayNode enumValues = (ArrayNode)value.get(ENUM_VALUES);
        ObjectNode ruleNode = this.objectMapper.createObjectNode();
        ArrayNode assignmentNode = this.objectMapper.createArrayNode();
        if (enumValues == null || enumValues.isNull()) {
            return ruleNode;
        }
        for (int i = 0; i < enumValues.size(); ++i) {
            ArrayNode bussinessRuleNode;
            ArrayNode parameters;
            ObjectNode node = (ObjectNode)enumValues.get(i);
            String ruleCode = node.get(ID).asText();
            ApproveCandidateRule record = new ApproveCandidateRule();
            record.setCode(ruleCode);
            record = this.candidateRuleMapper.selectOne(record);
            ObjectNode index = this.objectMapper.createObjectNode();
            index.put(ID, i);
            index.put(CODE, ruleCode);
            String jsonMessage = node.get(NAME).textValue();
            JsonNode cadidate = null;
            try {
                cadidate = this.objectMapper.readTree(jsonMessage);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if ("APPOINTED_POSITION".equalsIgnoreCase(ruleCode)) {
                ArrayNode parameters2 = (ArrayNode)cadidate.get("parameter");
                String positionCode = null;
                for (JsonNode parameter : parameters2) {
                    if (parameter.get("positionCode") == null) continue;
                    positionCode = parameter.get("positionCode").textValue();
                    break;
                }
                if (StringUtils.isNotEmpty(positionCode)) {
                    IRequest iRequest = RequestHelper.newEmptyRequest();
                    iRequest.setLocale("zh_CN");
                    RequestHelper.setCurrentRequest(iRequest);
                    Position position = this.positionMapper.getPositionByCode(positionCode);
                    RequestHelper.clearCurrentRequest();
                    index.put(ASSIGNEE_CODE, positionCode);
                    index.put(ASSIGNEE_NAME, positionCode);
                    if (position != null) {
                        index.put(ASSIGNEE, position.getPositionId());
                        index.put(ASSIGNEE_NAME, position.getName());
                    } else {
                        logger.error("no position with code:" + positionCode);
                    }
                }
            } else if ("APPOINTED_EMPLOYEE".equalsIgnoreCase(ruleCode)) {
                String employeeCode = null;
                parameters = (ArrayNode)cadidate.get("parameter");
                for (JsonNode parameter : parameters) {
                    if (parameter.get("employeeCode") == null) continue;
                    employeeCode = parameter.get("employeeCode").textValue();
                    break;
                }
                if (StringUtils.isNotEmpty(employeeCode)) {
                    index.put(ASSIGNEE_CODE, employeeCode);
                    index.put(ASSIGNEE_NAME, employeeCode);
                    Employee employee = this.employeeMapper.queryByCode(employeeCode);
                    if (employee != null) {
                        index.put(ASSIGNEE, employee.getEmployeeCode());
                        index.put(ASSIGNEE_NAME, employee.getName());
                    } else {
                        logger.error("no employee with code:" + employeeCode);
                    }
                }
            } else if ("APPOINTED_ROLE".equalsIgnoreCase(ruleCode)) {
                String roleCode = null;
                parameters = (ArrayNode)cadidate.get("parameter");
                for (JsonNode parameter : parameters) {
                    if (parameter.get("roleCode") == null) continue;
                    roleCode = parameter.get("roleCode").textValue();
                    break;
                }
                if (StringUtils.isNotEmpty(roleCode)) {
                    index.put(ASSIGNEE_CODE, roleCode);
                    index.put(ASSIGNEE_NAME, roleCode);
                    Role role = new Role();
                    role.setRoleCode(roleCode);
                    IRequest iRequest = RequestHelper.newEmptyRequest();
                    iRequest.setLocale("zh_CN");
                    RequestHelper.setCurrentRequest(iRequest);
                    role = this.roleMapper.selectOne(role);
                    RequestHelper.clearCurrentRequest();
                    if (role != null) {
                        index.put(ASSIGNEE, role.getRoleCode());
                        index.put(ASSIGNEE_NAME, role.getRoleName());
                    } else {
                        logger.error("no employee with code:" + roleCode);
                    }
                }
            }
            if (record != null) {
                index.put(DESCRIPTION, record.getDescription());
            }
            if ((bussinessRuleNode = this.processBussinessRuleNode((ObjectNode)cadidate)) != null) {
                index.set(RULES, (JsonNode)bussinessRuleNode);
            }
            assignmentNode.add((JsonNode)index);
        }
        ruleNode.set("assignment", (JsonNode)assignmentNode);
        return ruleNode;
    }

    private ArrayNode processBussinessRuleNode(ObjectNode node) {
        ArrayNode businessRuleNode = null;
        ArrayNode businessRules = (ArrayNode)node.get("businessRules");
        if (businessRules != null) {
            businessRuleNode = this.objectMapper.createArrayNode();
            for (JsonNode index : businessRules) {
                ObjectNode ruleNode = (ObjectNode)index;
                String ruleCode = ruleNode.get(CODE.toUpperCase()).textValue();
                ObjectNode objectNode = this.objectMapper.createObjectNode();
                objectNode.put(CODE, ruleCode);
                objectNode.put("businessRuleCode", ruleCode);
                BusinessRuleHeader rule = this.businessRuleHeaderMapper.selectByCode(ruleCode);
                if (rule != null) {
                    objectNode.put("businessRuleDescription", rule.getDescription());
                } else {
                    logger.error("no business rule  with code" + ruleCode);
                }
                businessRuleNode.add((JsonNode)objectNode);
            }
        }
        return businessRuleNode;
    }

    private ApproveCandidateRule getCandidateRule(String code) {
        ApproveCandidateRule record = new ApproveCandidateRule();
        record.setCode(code);
        record.setEnableFlag(YES);
        record = this.candidateRuleMapper.selectOne(record);
        return record;
    }

    private boolean hasPermission(JsonNode ruleMap, DelegateExecution execution) {
        if (ruleMap == null) {
            return true;
        }
        ExpressionManager expressionManager = this.processEngineConfiguration.getExpressionManager();
        ArrayNode rules = (ArrayNode)ruleMap.get("businessRules");
        if (rules == null) {
            return true;
        }
        BusinessRuleLine line = new BusinessRuleLine();
        Date now = new Date();
        for (JsonNode rule : rules) {
            String code = rule.get(CODE.toUpperCase()).textValue();
            if (StringUtils.isEmpty((String)code)) continue;
            BusinessRuleHeader header = this.businessRuleHeaderMapper.selectByCode(code);
            if (header == null) {
                logger.warn("businessRule is disable or not exist");
                continue;
            }
            Date startDate = header.getStartActiveDate();
            Date endDate = header.getEndActiveDate();
            if (startDate != null && now.before(startDate)) {
                logger.warn("now before startDate ,businessRule is disable");
                continue;
            }
            if (endDate != null && now.after(endDate)) {
                logger.warn("now after startDate ,businessRule is disable");
                continue;
            }
            line.setBusinessRuleId(header.getBusinessRuleId());
            line.setEnableFlag(YES);
            List<BusinessRuleLine> lines = this.businessRuleLineMapper.select(line);
            for (BusinessRuleLine ruleLine : lines) {
                try {
                    Object result = expressionManager.createExpression(ruleLine.getConditions()).getValue((VariableScope)execution);
                    if (!Boolean.FALSE.equals(result)) continue;
                    return false;
                }
                catch (Exception e) {
                    logger.warn("condition fail", (Throwable)e);
                    return true;
                }
            }
        }
        return true;
    }
}

