/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.activiti.components;

import com.hand.hap.core.IRequest;
import com.hand.hap.mybatis.common.Criteria;
import com.hand.hap.mybatis.common.query.WhereField;
import com.hand.hap.system.dto.Prompt;
import com.hand.hap.system.mapper.PromptMapper;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;

@Component
public class ActivitiMultiLanguageManager
implements InitializingBean {
    @Autowired
    private ApplicationContext applicationContext;
    private static MessageSource messageSource;
    private static PromptMapper promptMapper;
    public static boolean multiLanguageOpen;
    public static String multiLanguagePrefix;

    @Value(value="${activiti.multiLanguage.open:false}")
    public void setMultiLanguageOpen(boolean multiLanguageOpen) {
        ActivitiMultiLanguageManager.multiLanguageOpen = multiLanguageOpen;
    }

    @Value(value="${activiti.multiLanguage.prefix:act.}")
    public void setMultiLanguagePrefix(String multiLanguagePrefix) {
        ActivitiMultiLanguageManager.multiLanguagePrefix = multiLanguagePrefix;
    }

    public static String getMultLanguageInfoByCode(String code, IRequest iRequest) {
        if (multiLanguageOpen) {
            boolean isQuery;
            boolean bl = isQuery = StringUtils.isNotEmpty((String)code) && (code.startsWith(multiLanguagePrefix) || "hap.process.start".equals(code) || "hap.process.end".equals(code));
            if (isQuery) {
                code = messageSource.getMessage(code, null, LocaleUtils.toLocale((String)iRequest.getLocale()));
            }
        }
        return code;
    }

    public static String getMultiLanguageInfoByDescription(String description, IRequest iRequest) {
        if (StringUtils.isNotEmpty((String)description)) {
            Prompt prompt = new Prompt();
            prompt.setLang(iRequest.getLocale());
            prompt.setDescription(description);
            Criteria criteria = new Criteria(prompt);
            criteria.select("promptCode");
            criteria.where(new WhereField("description"));
            List<Prompt> prompts = promptMapper.selectOptions(prompt, criteria);
            if (CollectionUtils.isNotEmpty(prompts)) {
                for (Prompt prompt1 : prompts) {
                    String code = prompt1.getPromptCode();
                    if (!StringUtils.isNotEmpty((String)code) || !code.startsWith(multiLanguagePrefix)) continue;
                    description = code;
                    break;
                }
            }
        }
        return description;
    }

    public void afterPropertiesSet() throws Exception {
        messageSource = (MessageSource)this.applicationContext.getBean(MessageSource.class);
        promptMapper = (PromptMapper)this.applicationContext.getBean(PromptMapper.class);
    }
}

