/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.account.service.impl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.StringUtil;
import com.hand.hap.account.dto.User;
import com.hand.hap.account.exception.UserException;
import com.hand.hap.account.mapper.UserMapper;
import com.hand.hap.account.mapper.UserRoleMapper;
import com.hand.hap.account.service.IRole;
import com.hand.hap.account.service.IRoleService;
import com.hand.hap.account.service.IUserService;
import com.hand.hap.cache.impl.ResourceItemAssignCache;
import com.hand.hap.cache.impl.RoleFunctionCache;
import com.hand.hap.cache.impl.UserCache;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.annotation.StdWho;
import com.hand.hap.core.util.ValidateUtils;
import com.hand.hap.function.dto.Function;
import com.hand.hap.function.dto.MenuItem;
import com.hand.hap.function.dto.Resource;
import com.hand.hap.function.dto.ResourceItemAssign;
import com.hand.hap.function.mapper.ResourceItemAssignMapper;
import com.hand.hap.function.service.IFunctionService;
import com.hand.hap.function.service.IRoleFunctionService;
import com.hand.hap.function.service.IRoleResourceItemService;
import com.hand.hap.mybatis.common.Criteria;
import com.hand.hap.security.CustomUserDetails;
import com.hand.hap.security.IUserSecurityStrategy;
import com.hand.hap.security.PasswordManager;
import com.hand.hap.security.service.impl.UserSecurityStrategyManager;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserServiceImpl
extends BaseServiceImpl<User>
implements IUserService {
    @Autowired
    private PasswordManager passwordManager;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    UserSecurityStrategyManager userSecurityStrategyManager;
    @Autowired
    @Qualifier(value="roleServiceImpl")
    private IRoleService roleService;
    @Autowired
    private UserRoleMapper userRoleMapper;
    @Autowired
    private IFunctionService functionService;
    @Autowired
    private IRoleFunctionService roleFunctionService;
    @Autowired
    private IRoleResourceItemService roleResourceItemService;
    @Autowired
    private ResourceItemAssignCache resourceItemAssignCache;
    @Autowired
    private ResourceItemAssignMapper resourceItemAssignMapper;
    @Autowired
    private RoleFunctionCache roleFunctionCache;
    @Autowired
    private UserCache userCache;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public User insertSelective(IRequest request, @StdWho User record) {
        if (StringUtils.isEmpty((String)record.getPassword())) {
            record.setPassword(this.passwordManager.getDefaultPassword());
        }
        record.setUserName(record.getUserName().toLowerCase());
        record.setPasswordEncrypted(this.passwordManager.encode(record.getPassword()));
        List<IUserSecurityStrategy> userSecurityStrategies = this.userSecurityStrategyManager.getUserSecurityStrategyList();
        for (IUserSecurityStrategy userSecurityStrategy : userSecurityStrategies) {
            record = userSecurityStrategy.beforeCreateUser(request, record);
        }
        record = super.insertSelective(request, record);
        this.userMapper.updatePassword(record.getUserId(), record.getPasswordEncrypted());
        return record;
    }

    @Override
    public void validateEmail(String email) throws UserException {
        if (!ValidateUtils.validateEmail(email)) {
            throw new UserException("error.user.email", new Object[0]);
        }
    }

    @Override
    public void validatePhone(String phone) throws UserException {
        if (!ValidateUtils.validatePhone(phone)) {
            throw new UserException("error.user.phone", new Object[0]);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public User login(User user) throws UserException {
        if (user == null || org.apache.commons.lang3.StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{user.getUserName(), user.getPassword()})) {
            throw new UserException("error.login.name_password_not_match", "error.login.name_password_not_match", null);
        }
        User user1 = this.userMapper.selectByUserName(user.getUserName());
        if (user1 == null) {
            throw new UserException("error.login.name_password_not_match", "error.login.name_password_not_match", null);
        }
        if ("LOCK".equals(user1.getStatus())) {
            throw new UserException("error.user.account_expired", "error.user.account_expired", null);
        }
        if (user1.getStartActiveDate() != null && user1.getStartActiveDate().getTime() > System.currentTimeMillis()) {
            throw new UserException("error.user.account_expired", "error.user.account_expired", null);
        }
        if (user1.getEndActiveDate() != null && user1.getEndActiveDate().getTime() < System.currentTimeMillis()) {
            throw new UserException("error.user.account_expired", "error.user.account_expired", null);
        }
        if (!this.passwordManager.matches(user.getPassword(), user1.getPasswordEncrypted())) {
            throw new UserException("error.login.name_password_not_match", "error.login.name_password_not_match", null);
        }
        return user1;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public User selectByUserName(String userName) {
        User user = this.userCache.getValue(userName = userName.toLowerCase());
        if (null == user && null != (user = this.userMapper.selectByUserName(userName))) {
            this.userCache.setValue(userName, user);
        }
        return user;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<User> selectUserNameByEmployeeCode(String employeeCode) {
        return this.userMapper.selectUserNameByEmployeeCode(employeeCode);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public User updateByPrimaryKeySelective(IRequest request, @StdWho User record) {
        int count = this.userMapper.updateBasic(record);
        this.checkOvn(count, record);
        this.userCache.remove(record.getUserName());
        return record;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updatePassword(Long userId, String userName, String password) {
        this.userMapper.updatePassword(userId, this.passwordManager.encode(password));
        this.userCache.remove(userName);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public void validatePassword(IRequest request, String newPwd, String newPwdAgain) throws UserException {
        List<IUserSecurityStrategy> userSecurityStrategies = this.userSecurityStrategyManager.getUserSecurityStrategyList();
        for (IUserSecurityStrategy userSecurityStrategy : userSecurityStrategies) {
            userSecurityStrategy.validatePassword(newPwd, newPwdAgain);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateNotFirstLogin(Long userId, String status) {
        this.userMapper.updateFirstLogin(userId, status);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<User> selectUsers(IRequest request, User user, int pageNum, int pageSize) {
        if (user != null && StringUtil.isNotEmpty(user.getUserName())) {
            user.setUserName(user.getUserName().toLowerCase());
        }
        PageHelper.startPage(pageNum, pageSize);
        return this.userMapper.selectUsersOption(user);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<IRole> selectUserAndRoles(IRequest request, User user, int pageNum, int pageSize) {
        return this.roleService.selectRolesByUser(request, user);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<MenuItem> queryFunction(IRequest requestContext, Long userId) {
        List<MenuItem> menus = this.functionService.selectAllMenus(requestContext);
        Set<Long> userFunctionIds = null;
        if (userId != null) {
            userFunctionIds = this.getUserFunctionIds(requestContext.getAllRoleId());
        }
        return this.updateMenu(menus, userFunctionIds);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<MenuItem> queryResourceItems(IRequest requestContext, Long userId, Long functionId) {
        Function function = new Function();
        function.setFunctionId(functionId);
        List<Resource> resources = this.roleResourceItemService.queryHtmlResources(requestContext, function);
        List<MenuItem> menus = this.updateResourceMenu(this.roleResourceItemService.createResources(resources));
        if (CollectionUtils.isEmpty(menus)) {
            return menus;
        }
        List<Long> allAssignElementIds = this.getAllAssignElementIds(userId, Arrays.asList(requestContext.getAllRoleId()));
        if (CollectionUtils.isEmpty(allAssignElementIds)) {
            return menus;
        }
        return this.updateMenuCheck(menus, allAssignElementIds);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<ResourceItemAssign> updateResourceItemAssign(IRequest requestContext, List<ResourceItemAssign> resourceItemAssignList, Long userId, Long functionId) {
        this.resourceItemAssignMapper.deleteByUserIdAndFunctionId(userId, functionId);
        if (CollectionUtils.isNotEmpty(resourceItemAssignList)) {
            for (ResourceItemAssign resourceItemAssign : resourceItemAssignList) {
                resourceItemAssign.setAssignType("user");
                resourceItemAssign.setFunctionId(functionId);
                this.resourceItemAssignMapper.insertSelective(resourceItemAssign);
            }
        }
        this.resourceItemAssignCache.load("user_" + userId);
        return resourceItemAssignList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteResourceItems(Long userId, Long functionId) {
        this.resourceItemAssignMapper.deleteByUserIdAndFunctionId(userId, functionId);
        this.resourceItemAssignCache.load("user_" + userId);
    }

    @Override
    public void resetPassword(IRequest request, User user, String passwordAgain) throws UserException {
        String password = user.getPassword();
        this.validatePassword(request, password, passwordAgain);
        user = (User)this.userMapper.selectByPrimaryKey(user);
        ((IUserService)this.self()).updatePassword(user.getUserId(), user.getUserName(), password);
    }

    @Override
    public void firstAndExpiredLoginUpdatePassword(IRequest request, String newPassword, String newPasswordAgain) throws UserException {
        Long accountId = request.getUserId();
        String userName = request.getUserName();
        this.validatePassword(request, newPassword, newPasswordAgain);
        ((IUserService)this.self()).updatePassword(accountId, userName, newPassword);
        ((IUserService)this.self()).updateNotFirstLogin(accountId, "N");
    }

    @Override
    public void updateOwnerPassword(IRequest request, String oldPassword, String newPassword, String newPasswordAgain) throws UserException {
        Long accountId = request.getUserId();
        String userName = request.getUserName();
        this.validatePassword(request, newPassword, newPasswordAgain);
        if (StringUtils.isEmpty((String)oldPassword)) {
            throw new UserException("error.user.password_not_empty", null);
        }
        User tmp = new User();
        tmp.setUserId(accountId);
        User userInDB = this.selectByPrimaryKey(request, tmp);
        String pwd = userInDB.getPasswordEncrypted();
        if (!this.passwordManager.matches(oldPassword, pwd)) {
            throw new UserException("error.password.current_password", null);
        }
        if (this.passwordManager.matches(newPassword, pwd)) {
            throw new UserException("error.system.not_allowed_same_with_old_password", null);
        }
        ((IUserService)this.self()).updatePassword(accountId, userName, newPassword);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<User> batchUpdate(IRequest request, List<User> list) {
        Criteria criteria = new Criteria();
        criteria.update("employeeId", "email", "phone", "status", "endActiveDate", "startActiveDate", "description");
        criteria.updateExtensionAttribute();
        for (User user : list) {
            switch (user.get__status()) {
                case "add": {
                    ((IUserService)this.self()).insertSelective(request, user);
                    break;
                }
                case "update": {
                    this.userCache.remove(user.getUserName());
                    ((IUserService)this.self()).updateByPrimaryKeyOptions(request, user, criteria);
                    break;
                }
            }
        }
        return list;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int deleteByPrimaryKey(User user) {
        int ret = super.deleteByPrimaryKey(user);
        this.userRoleMapper.deleteByUserId(user.getUserId());
        this.userCache.remove(user.getUserName());
        return ret;
    }

    @Override
    public User convertToUser(UserDetails userDetails) {
        if (userDetails instanceof CustomUserDetails) {
            CustomUserDetails customUserDetails = (CustomUserDetails)userDetails;
            User user = new User();
            user.setUserId(customUserDetails.getUserId());
            user.setUserName(customUserDetails.getUsername());
            user.setEmployeeId(customUserDetails.getEmployeeId());
            user.setEmployeeCode(customUserDetails.getEmployeeCode());
            Collection<? extends GrantedAuthority> authorities = customUserDetails.getAuthorities();
            ArrayList<String> roleCodes = new ArrayList<String>();
            for (GrantedAuthority grantedAuthority : authorities) {
                if (grantedAuthority.getAuthority().equals("ROLE_USER")) continue;
                roleCodes.add(grantedAuthority.getAuthority());
            }
            user.setRoleCode(roleCodes);
            return user;
        }
        return this.selectByUserName(userDetails.getUsername());
    }

    @Override
    public List<Long> getAllAssignElementIds(Long userId, List<Long> roleIds) {
        ArrayList<Long> allAssignElementIds = new ArrayList<Long>();
        if (userId != null) {
            if (CollectionUtils.isEmpty(roleIds)) {
                return null;
            }
            List<Long> roleAssignElementIds = this.getAllRoleAssignElementIds(roleIds);
            Object[] userAssigns = this.resourceItemAssignCache.getValue("user_" + userId);
            if (ArrayUtils.isEmpty((Object[])userAssigns)) {
                if (CollectionUtils.isNotEmpty(roleAssignElementIds)) {
                    allAssignElementIds.addAll(roleAssignElementIds);
                }
                return allAssignElementIds;
            }
            for (Object userAssign : userAssigns) {
                if (!"N".equalsIgnoreCase(((ResourceItemAssign)userAssign).getEnable())) continue;
                allAssignElementIds.add(((ResourceItemAssign)userAssign).getElementId());
            }
            if (CollectionUtils.isNotEmpty(roleAssignElementIds)) {
                for (Long roleAssignElementId : roleAssignElementIds) {
                    boolean check = true;
                    for (Object userAssign : userAssigns) {
                        if (!roleAssignElementId.equals(((ResourceItemAssign)userAssign).getElementId())) continue;
                        check = false;
                        break;
                    }
                    if (!check) continue;
                    allAssignElementIds.add(roleAssignElementId);
                }
            }
        }
        return allAssignElementIds;
    }

    private List<MenuItem> updateMenu(List<MenuItem> menus, Set<Long> userFunctionIds) {
        if (CollectionUtils.isEmpty(menus) || CollectionUtils.isEmpty(userFunctionIds)) {
            return new ArrayList<MenuItem>();
        }
        Iterator<MenuItem> iterator = menus.iterator();
        while (iterator.hasNext()) {
            boolean hasFunction;
            MenuItem menu = iterator.next();
            boolean hasChild = false;
            if (CollectionUtils.isNotEmpty(menu.getChildren())) {
                hasChild = CollectionUtils.isNotEmpty(this.updateMenu(menu.getChildren(), userFunctionIds));
            }
            if ((hasFunction = userFunctionIds.contains(menu.getId())) || hasChild) continue;
            iterator.remove();
        }
        return menus;
    }

    private Set<Long> getUserFunctionIds(Long[] allRoleIds) {
        if (ArrayUtils.isEmpty((Object[])allRoleIds)) {
            return null;
        }
        HashSet<Long> userFunctionIds = new HashSet<Long>();
        for (Long roleId : allRoleIds) {
            Object[] functionIds = this.roleFunctionService.getRoleFunctionById(roleId);
            if (!ArrayUtils.isNotEmpty((Object[])functionIds)) continue;
            userFunctionIds.addAll(Arrays.asList(functionIds));
        }
        return userFunctionIds;
    }

    private List<MenuItem> updateMenuCheck(List<MenuItem> menus, List<Long> allAssignElementIds) {
        if (CollectionUtils.isEmpty(menus) || CollectionUtils.isEmpty(allAssignElementIds)) {
            return menus;
        }
        for (MenuItem menuItem : menus) {
            if (CollectionUtils.isNotEmpty(menuItem.getChildren())) {
                this.updateMenuCheck(menuItem.getChildren(), allAssignElementIds);
            }
            if (!allAssignElementIds.contains(menuItem.getId())) continue;
            menuItem.setIschecked(Boolean.FALSE);
        }
        return menus;
    }

    private List<Long> getSameFunctionIds(Set<Long> allRoleFunctionIds, Set<Long> roleFunctionIds) {
        allRoleFunctionIds.retainAll(roleFunctionIds);
        return new ArrayList<Long>(allRoleFunctionIds);
    }

    private List<Long> compareFunctionElements(List<Long> allFunctionElements, List<Long> functionElementIds) {
        if (CollectionUtils.isEmpty(allFunctionElements) || CollectionUtils.isEmpty(functionElementIds)) {
            return new ArrayList<Long>();
        }
        allFunctionElements.retainAll(functionElementIds);
        return allFunctionElements;
    }

    private Map<Long, List<Long>> getFunctionElements(ResourceItemAssign[] assigns) {
        HashMap<Long, List<Long>> function = new HashMap<Long, List<Long>>(16);
        if (ArrayUtils.isNotEmpty((Object[])assigns)) {
            for (ResourceItemAssign assign : assigns) {
                ArrayList<Long> functionElements = (ArrayList<Long>)function.get(assign.getFunctionId());
                if (CollectionUtils.isEmpty((Collection)functionElements)) {
                    functionElements = new ArrayList<Long>();
                    function.put(assign.getFunctionId(), functionElements);
                }
                functionElements.add(assign.getElementId());
            }
        }
        return function;
    }

    private List<Long> getAllRoleAssignElementIds(List<Long> roleIds) {
        ArrayList<Long> allRoleAssignElementIds = new ArrayList<Long>();
        Map<Object, Object> allFunctionElements = new HashMap<Long, List>(16);
        boolean firstRole = true;
        HashSet<Long> allRoleFunctionIds = new HashSet<Long>();
        for (Long roleId : roleIds) {
            Object[] roleFunctionIdList = this.roleFunctionCache.getValue(roleId.toString());
            if (ArrayUtils.isEmpty((Object[])roleFunctionIdList)) continue;
            HashSet<Long> roleFunctionIds = new HashSet<Long>();
            CollectionUtils.addAll(roleFunctionIds, (Object[])roleFunctionIdList);
            Map<Long, List<Long>> functionElements = this.getFunctionElements(this.resourceItemAssignCache.getValue("role_" + roleId));
            if (firstRole) {
                firstRole = false;
                allRoleFunctionIds = roleFunctionIds;
                allFunctionElements = functionElements;
                continue;
            }
            List<Long> sameFunctionIds = this.getSameFunctionIds(allRoleFunctionIds, roleFunctionIds);
            for (Long roleFunctionId : roleFunctionIds) {
                if (sameFunctionIds.contains(roleFunctionId)) continue;
                allFunctionElements.put(roleFunctionId, functionElements.get(roleFunctionId));
            }
            for (Long sameFunctionId : sameFunctionIds) {
                List<Long> elements = this.compareFunctionElements((List)allFunctionElements.get(sameFunctionId), functionElements.get(sameFunctionId));
                allFunctionElements.put(sameFunctionId, elements);
            }
            allRoleFunctionIds.addAll(roleFunctionIds);
        }
        allFunctionElements.forEach((k, v) -> {
            if (v != null) {
                allRoleAssignElementIds.addAll((Collection<Long>)v);
            }
        });
        return allRoleAssignElementIds;
    }

    private List<MenuItem> updateResourceMenu(List<MenuItem> menus) {
        if (CollectionUtils.isEmpty(menus)) {
            return menus;
        }
        this.removeVariableMenu(menus);
        Iterator<MenuItem> iterator = menus.iterator();
        while (iterator.hasNext()) {
            MenuItem menu = iterator.next();
            if (!CollectionUtils.isEmpty(menu.getChildren())) continue;
            iterator.remove();
        }
        return menus;
    }

    private void removeVariableMenu(List<MenuItem> menus) {
        Iterator<MenuItem> iterator = menus.iterator();
        while (iterator.hasNext()) {
            MenuItem menu = iterator.next();
            if ("\u670d\u52a1\u7aef\u53d8\u91cf".equalsIgnoreCase(menu.getText())) {
                iterator.remove();
                break;
            }
            if (!CollectionUtils.isNotEmpty(menu.getChildren())) continue;
            this.removeVariableMenu(menu.getChildren());
        }
    }
}

