/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.task.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.task.dto.TaskAssign;
import com.hand.hap.task.service.ITaskAssignService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/task/assign", "/api/sys/task/assign"})
public class TaskAssignController
extends BaseController {
    @Autowired
    private ITaskAssignService service;

    @RequestMapping(value={"/query"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseData query(TaskAssign dto, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.service.query(requestContext, dto));
    }

    @PostMapping(value={"/submit"})
    public ResponseData update(@RequestBody List<TaskAssign> dto, BindingResult result, HttpServletRequest request) {
        this.getValidator().validate(dto, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        IRequest requestCtx = this.createRequestContext(request);
        return new ResponseData(this.service.batchUpdate(requestCtx, dto));
    }

    @PostMapping(value={"/remove"})
    public ResponseData remove(HttpServletRequest request, @RequestBody List<TaskAssign> dto) {
        this.service.batchDelete(dto);
        return new ResponseData();
    }

    @PostMapping(value={"/selectUnbound"})
    public ResponseData queryUnbound(@RequestParam(required=false) String ids, HttpServletRequest request) {
        IRequest iRequest = this.createRequestContext(request);
        List<String> idList = new ArrayList<String>();
        if (ids != null && !ids.isEmpty()) {
            idList = Arrays.asList(ids.split(","));
        }
        return new ResponseData(this.service.queryUnbound(iRequest, idList));
    }
}

