/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.system.controllers.sys;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.Language;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.service.ILanguageService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/language", "/api/sys/language"})
public class LanguageController
extends BaseController {
    @Autowired
    private ILanguageService languageService;

    @PostMapping(value={"/query"})
    public ResponseData query(HttpServletRequest request, Language example, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize) {
        IRequest iRequest = this.createRequestContext(request);
        return new ResponseData(this.languageService.select(iRequest, example, page, pagesize));
    }

    @PostMapping(value={"/submit"})
    public ResponseData submit(HttpServletRequest request, @RequestBody List<Language> languageList, BindingResult result) {
        this.getValidator().validate(languageList, (Errors)result);
        if (result.hasErrors()) {
            ResponseData rs = new ResponseData(false);
            rs.setMessage(this.getErrorMessage((Errors)result, request));
            return rs;
        }
        IRequest iRequest = this.createRequestContext(request);
        return new ResponseData(this.languageService.submit(iRequest, languageList));
    }

    @PostMapping(value={"/remove", "/delete"})
    public ResponseData delete(HttpServletRequest request, @RequestBody List<Language> languageList) {
        this.languageService.remove(languageList);
        return new ResponseData();
    }
}

